/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* Definitions for WS-Management SOAP headers management.
* This API has been specifically designed for an external WS-Management
* implementation.
*******************************************************************************/

#ifndef WSMANTYPES_H_
#define WSMANTYPES_H_

/** WS-Management resource selector restricted to simple content value. */
struct wsman_selector {
	/** The id of the selector. */
	char * name;
	/** The text value of the selector */
	char * value;
};

/** A generic XPath expression with namespace prefix definitions allowing its
 * processing.
 */
struct xpath_expression {
	/** The number of entries in the prefix definition array. */
	int nb_pfx_def;
	/** NULL-terminated prefix definitions array for the XPath expression */
	struct prefix_def * ns_ctx;
	/** An unparsed XPath expression */
	char * exp;
};

/** WS-Management reference parameters. */
struct wsman_ref_params {
	/** Resource URI */
	char * resource_uri;
	/** The number of resource instance selectors */
	int nb_selectors;
	/** An array of resource instance selectors */
	struct wsman_selector * selectors;	// array of struct wsman_selector
};

/** WS-Management headers. */
struct wsman_headers {
	/** Resource URI */
	struct wsman_ref_params ref_params;
	/** A parsable XPath expression */
	struct xpath_expression * fragment_transfer;
	/** A hearbeats duration. Uses the format for XSD Duration types */
	char * heartbeats;
	/** A bookmark request */
	char * bookmark;
};

#endif /*WSMANTYPES_H_*/
