/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* XML definitions for EPX.
*******************************************************************************/

#ifndef XMLTYPES_H_
#define XMLTYPES_H_

/*----------------------------------------------------------------------------*\
 *                                   Macros                                   *
\*----------------------------------------------------------------------------*/

#define QNAME_EQUALS(ns1, ln1, ns2, ln2) (!strcmp(ln1, ln2) && (ns1 ? (ns2 ? !strcmp(ns1, ns2) : 0) : ns2 == NULL))	/**< Compares QNames */
#define QNAME_NOT_EQUALS(ns1, ln1, ns2, ln2) (strcmp(ln1, ln2) || (ns1 ? (ns2 ? strcmp(ns1, ns2) : 1) : ns2 != NULL))	/**< Compares QNames */
#define QNAME_EQUALS_WILDCARD(ns, ln, ref_ns, ref_ln) (!ref_ln || (!strcmp(ln, ref_ln) && (ns ? (ref_ns ? !strcmp(ns, ref_ns) : 0) : ref_ns == NULL)))	/**< Compares QNames considering NULL namespace as any namespace */
#define QNAME_NOT_EQUALS_WILDCARD(ns, ln, ref_ns, ref_ln) ((ref_ln && strcmp(ln, ref_ln)) || (ref_ns && (!ns || strcmp(ns, ref_ns))))	/**< Compares QNames considering NULL namespace as any namespace */

#define QNAME_STRUCT_EQUALS(qn1, qn2) QNAME_EQUALS(qn1->ns, qn1->lname, qn2->ns, qn2->lname)	/**< Compares QNames */
#define QNAME_STRUCT_NOT_EQUALS(qn1, qn2) QNAME_NOT_EQUALS(qn1->ns, qn1->lname, qn2->ns, qn2->lname)	/**< Compares QNames */
#define QNAME_STRUCT_EQUALS_WILDCARD(qn, ref_qn) QNAME_EQUALS_WILDCARD(qn->ns, qn->lname, ref_qn->ns, ref_qn->lname)	/**< Compares QNames considering NULL namespace as any namespace */
#define QNAME_STRUCT_NOT_EQUALS_WILDCARD(qn, ref_qn) QNAME_NOT_EQUALS_WILDCARD(qn->ns, qn->lname, ref_qn->ns, ref_qn->lname)	/**< Compares QNames considering NULL namespace as any namespace */

/*----------------------------------------------------------------------------*\
 *                                 Constants                                  *
\*----------------------------------------------------------------------------*/

#define EPX_XML_NS_URI "http://www.w3.org/XML/1998/namespace"	/**< XML namespace URI */
#define EPX_XML_NS_PREFIX "xml"	/**< Implicit predefined <em>xml</em> prefix */

/*----------------------------------------------------------------------------*\
 *                                   Types                                    *
\*----------------------------------------------------------------------------*/

/** Boolean type.
 */
typedef enum {EPX_FALSE = 0, EPX_TRUE = 1} epx_boolean_t;

/** An XML qualified name used for instance for WS-Discovery port types.
 */
typedef struct epx_qname
{
	char * ns;	/**< Namespace. */
	char * lname;	/**< Local name. */
} epx_qname_t;

#endif /*XMLTYPES_H_*/
