/*============================================================================*\
|                                                                              |
|                         =S= DPWS toolkit Samples                             |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|                                                                              |
|                                + File info:                                  |
|                                              $Revision: 1.2 $
|                                              $Date: 2008/02/11 10:17:17 $
\*============================================================================*/
#include <pthread.h>
#include <stdio.h>
#include <sys/time.h>

#include "dc/dc_Dpws.h"

pthread_t bootThread;	// Main loop thread monitoring incoming messages.

static void* runServer(struct dpws * m_dpws);
static void* serve(struct dpws * dpws);
extern void shutdownProgram(struct dpws * dpws);	// see client.c & server.c for implementation

/* Start server message listener */
int bootServer(struct dpws *dpws)
{
	int status = 0;
	if ((status = pthread_create(&bootThread, NULL, (void * (*)(void *))runServer, dpws))) {
	    fprintf (stderr, "Thread Creation ERROR (%d) - bootServer()\n", status);
	    return status;
	}
	return 0;
}

/* Multi-thread message listener task */
static void* runServer(struct dpws * m_dpws)
{
	pthread_t hThread;
	struct dpws * s_dpws;
	int status = DPWS_OK;

    while (1) {
		/*
		IMPORTANT NOTE:
			This multi-thread server is supplied as an example for studying purpose	and
			does not meet the usual standards of industrial software. For instance,
			threads	should not create threads or allocate a runtime structure for every
			service but use	pools instead.
		 */

    	s_dpws = malloc(sizeof(struct dpws));	// Allocate a DPWS runtime structure for the next server task.

		status = dpws_accept_thr(m_dpws, s_dpws);
		if (status) {
			if (status != DPWS_ERR_SERVER_STOPPED) // The only status that is not really an error and allows normal exit of the server loop
				fprintf(stderr, dpws_get_error_msg(m_dpws));
			goto exit;
		}

		/* spawn a new thread */
		if ((status = pthread_create(&hThread, NULL, (void * (*)(void *))serve, s_dpws))) {
	        fprintf (stderr, "Thread Creation ERROR (%d) - runServer()\n", status);
	        goto exit;
		}
		pthread_detach(hThread);
	}

exit:
	free(s_dpws);	// free unused runtime structure.
	shutdownProgram(m_dpws);	// Performs a different DPWS cleaning for the server & the client.
	dpws_shutdown();	// Clean the DPWS stack.
	return NULL;
}

/* One-shot server task */
static void* serve(struct dpws * dpws)
{
	if (dpws_serve(dpws))	// performs message processing.
		fprintf(stderr, dpws_get_error_msg(dpws));	// Better thing to do on an embedded server is logging...
	dpws_end(dpws);	// frees transient message memory.
	free(dpws);
	return NULL;
}

/* Stops the server */
void stopServer()
{
	dpws_stop_server(1000);	// shutdowns the dpws listener and process all pending operations
	pthread_join(bootThread, NULL);	// wait for the master thread to exit
}

/*
 *  Utilities
 */

/* Makes the current thread sleep */
void portableSleep(int seconds)
{
	sleep(seconds);
}

/* Gets time in seconds whatever is the origin */
int32_t portableTime()
{
	struct timeval tv;
	gettimeofday(&tv, (struct timezone *)0);
	return (int32_t)tv.tv_sec;
}
