/*============================================================================*\
|                                                                              |
|                          SOA4D DPWSCore Samples                              |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|                                                                              |
|        + File info:                                                          |
|                     $Revision: 2125 $
|                     $Date: 2009-02-26 23:52:06 +0100 (jeu, 26 fév 2009) $
\*============================================================================*/
/******************************************************************************\
 *                   Simple light Static Service Class Loader                 *
\******************************************************************************/

#include "sscl_lit.h"

#include "litStub.h" // Generated stub & skeleton include file for light device implementation.
// #include "lit.nsmap" // already included by sscl_dim

#include "dc/dc_Epx.h"	// XML streaming processing API

/* Service class loader callback declarations. */
static int lit_new_service(short href_endpoint);
static int lit_free_service(short href_endpoint);
static int lit_serialize_impl(short href_sclass, void * szr_ctx);

/*
 *	Runtime data
 */

// Identifier for this service implementation (service class loader) used in the
// configuration file.
struct qname lit_iqn = {LIT_NS, LIT_ELT_SSCL_IMPL};

/* Callback associated to the previously defined qualified name.
   It will be called when the washer service class loader is loaded in order to
   initialize the various functions called when:
	+ a service of this class is created,
	+ a service of this class is deleted,
	+ the service class is to be serialized in XML for instance for configuration
	  backup,
	+ a request for a service is to be processed.
	See load_cbk reference for more information.
*/
int lit_load_cbk(short href_sclass, void * psr_ctx, dispatch_cbk * p_dispatch_cbk, struct scl_callbacks * p_cbks)
{
	/* Achieves implementation tag parsing with EPX (here very simple). Note that
	 * the current event is the 'implementation' start tag
	 */
	if (epx_next(psr_ctx) != EPX_EVT_END_ELEMENT || QNAME_NOT_EQUALS_WILDCARD(epx_get_ns_uri(psr_ctx), epx_get_lname(psr_ctx), LIT_NS, LIT_ELT_SSCL_IMPL))
		return DPWS_ERR_INCORRECT_IMPL_TAG;

	*p_dispatch_cbk = lit_serve_request;	// generated skeleton dispatch function.
	p_cbks->new_service = lit_new_service;	// service instance creation callback.
	p_cbks->free_service = lit_free_service;	// service instance deletion callback.
	p_cbks->serialize_impl = lit_serialize_impl;	// serialization callback
	return DPWS_OK;
}

/* Allows to initialize dimmer service runtime data on service creation. */
int lit_new_service(short href_endpoint)
{
	enum lit__PowerState * ps = malloc(sizeof(enum lit__PowerState));
	*ps = lit__PowerState__OFF;
	return dpws_set_ptr_att(href_endpoint, DPWS_PTR_USER_DATA, ps);
}

/* On service deletion the user data is freed using this callback. */
int lit_free_service(short href_endpoint)
{
	free(dpws_get_ptr_att(href_endpoint, DPWS_PTR_USER_DATA));
	return DPWS_OK;
}

/* Service class implementation tag serialization callback. */
int lit_serialize_impl(short href_sclass, void * szr_ctx)
{
	epx_start_element(szr_ctx, LIT_NS, LIT_ELT_SSCL_IMPL);	// Here the whole tag must be generated using EPX
	epx_define_prefix(szr_ctx, LIT_PREFIX, LIT_NS);
	epx_end_element(szr_ctx, LIT_NS, LIT_ELT_SSCL_IMPL);
	return DPWS_OK;
}


/*
 *                   Service operations
 */

/* Change the light ON/OFF state */
int __lit__Switch(struct dpws* dpws, enum lit__PowerState lit__Power)
{
	enum lit__PowerState * pState;

	// The hosting device or service user data can be retrieved in the context
	// using a set of APIs among which dpws_get_endpoint_user_data.
	pState = (enum lit__PowerState *)dpws_get_endpoint_user_data(dpws);
	/*
	IMPORTANT NOTE about user data:
		The protection of user data is not performed by the DPWS stack so user
		should normally provide it. Since the 'light' sample is mono-thread, no
		concurrency issue can happen.
	*/
	*pState = lit__Power;
	printf("--> Setting light %s\n", lit__Power == lit__PowerState__ON ? "ON" : "OFF");
	return DPWS_OK;
}

/* Retrieves the light ON/OFF status */
int __lit__GetStatus(struct dpws* dpws, enum lit__PowerState *lit__Power)
{
	printf("--> Requesting light status\n");
	*lit__Power = *(enum lit__PowerState *)dpws_get_endpoint_user_data(dpws);
	/*
	IMPORTANT NOTE about user data:
		The protection of user data is not performed by the DPWS stack so user
		should normally provide it. Since the 'light' sample is mono-thread, no
		concurrency issue can happen.
	*/
	printf("<-- Light status is %s\n", *lit__Power == lit__PowerState__ON ? "ON" : "OFF");
	return DPWS_OK;
}

