/*============================================================================*\
|                                                                              |
|                         =S= DPWS toolkit Samples                             |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|                                                                              |
|                                + File info:                                  |
|                                              $Revision: 1.2 $
|                                              $Date: 2008/02/11 10:17:17 $
\*============================================================================*/
#include <pthread.h>
#include <stdio.h>

#include "dc/dc_Dpws.h"

pthread_t bootThread;	// Main loop thread is also the server thread since this is a mono-thread implementation.

static void* runServer(struct dpws * dpws);

/* Start server message listener */
int bootServer(struct dpws *dpws)
{
	int status = 0;
	if ((status = pthread_create(&bootThread, NULL, (void* (*)(void*))runServer, dpws))) { // fork a thread for the server loop
	    fprintf (stderr, "Thread Creation ERROR (%d) - bootServer()\n", status);
	    return status;
	}
	return 0;
}

/* Single thread message listener */
static void* runServer(struct dpws * dpws)
{
	int status = DPWS_OK;

    while (1) {
		status = dpws_accept(dpws);	// monitors listening sockets for incoming messages
		if (status) {
			if (status != DPWS_ERR_SERVER_STOPPED) // The only status that is not really an error and allows normal exit of the server loop
				fprintf(stderr, dpws_get_error_msg(dpws));
			goto exit;
		}
		if (dpws_serve(dpws))	// performs message processing.
			fprintf(stderr, dpws_get_error_msg(dpws));	// Better thing to do on an embedded server is logging...
		dpws_end(dpws);	// frees transient message memory.
	}

exit:
	dpws_server_shutdown(dpws);	// Clean the DPWS registry.
	dpws_shutdown();	// Clean the stack.
	return NULL;
}

/* Stops the server */
void stopServer()
{
	dpws_stop_server(1000);	// shutdowns the dpws listener and process all pending operations
	pthread_join(bootThread, NULL);	// wait for the master thread to exit
}

