/*============================================================================*\
|                                                                              |
|                          SOA4D Abstraction Layer                             |
|                                                                              |
|               ->>  Copyright 2008 Schneider Electric SA <<-                  |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1.5 $
|                     $Date: 2008/01/25 17:59:20 $
\*============================================================================*/
/*******************************************************************************
*                        Network configuration access                          *
*******************************************************************************/
#ifndef AL_NET_H_
#define AL_NET_H_

/** \file
    Abstract Layer (AL): Network IP configuration retrieval API.
*/

#include "al_ip.h"

/**
 * Data structure containing the IP configuration for a network interface.
 */
typedef struct al_netif_info {
	char *name;	/**< The interface name. */
	unsigned char mac_address[6];	/**< The interface MAC address */
	unsigned short addr_nb;	/**< The number of IP addresses contained in the \a addrs field */
	/**
	 * A list of structures containing the IP (v4 or v6) addresses.
	 * Notes: could define a sockaddr structure to add the network mask.
	 */
	al_sockaddr_t * addrs;
	unsigned int interface_selector;
//	al_sockaddr_t * gateway;
} al_netif_info_t;

/*----------------------------------------------------------------------------*\
 *                           IP configuration access                          *
\*----------------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * Retrieves the IP configuration for a all available interfaces.
 * @param[out] netifs A callee-allocated network interface information structure
 * array.
 * @param nb_netifs[out] The number of network interface information structure
 * returned.
 * @return AL_SUCCESS if no error occured, an AL error code else.
 */
int al_get_netif_info(al_netif_info_t * netifs[], int * nb_netifs);

/**
 * Free memory allocated by a call to al_get_netif_info().
 */
void al_release_netif_info(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /*AL_NET_H_*/
