### Setup ###
SRC_SUBDIRS=ip net rtos libc stor
SRC_DIRS+=$(foreach dir,$(SRC_SUBDIRS), $(DC_AL_DIR)/targets/$(dir))
space:=$(empty) $(empty)
VPATH:=$(subst $(space),:,$(SRC_DIRS)):.
INC_DIRS= $(DC_AL_DIR)/include $(SRC_DIRS) $(DC_PLATFORM_DIR)/$(DC_TOOLCHAIN)/$(DC_TARGET)/include

### Files, includes and libraries ###
INCS=$(foreach dir,$(INC_DIRS), -I$(dir))
OBJS=$(SRCS:.c=.o)

### Compilation options ###
CIFLAGS=$(INCS)
CFLAGS=$(CWFLAGS) $(COFLAGS) $(CIFLAGS) $(CMFLAGS)

### Targets ###
all: static

.PHONY: all static clean cleanall distclean
		
static: lib$(DC_SC)$(STATIC_EXT)

lib$(DC_SC)$(STATIC_EXT): $(OBJS)
		$(AR) cr lib$(DC_SC)$(STATIC_EXT) $(OBJS)

$(OBJS): %.o: %.c
		$(CC) -c $(CPPFLAGS) $(CFLAGS) -o $@ $<

ifneq ($(MAKECMDGOALS),distclean)
ifneq ($(MAKECMDGOALS),cleanall)
ifneq ($(MAKECMDGOALS),clean)
-include $(SRCS:.c=.d)
endif
endif
endif

%.d: %.c
		$(SHELL) -ec '$(CC) -MM -MG $(CPPFLAGS) $(CIFLAGS) $< \
			| sed '\''s/\($*\)\.o[ :]*/\1.o $@ : /g'\'' > $@; \
			[ -s $@ ] || rm -f $@'

clean:
		-rm *.o *$(STATIC_EXT) $(CUSTOM_OUTPUT_FILES)

cleanall: clean
		-rm *.d

distclean: cleanall
