/*============================================================================*\
|                                                                              |
|                          SOA4D Abstraction Layer                             |
|                                                                              |
|               ->>  Copyright 2008 Schneider Electric SA <<-                  |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1.3 $
|                     $Date: 2008/02/05 18:06:16 $
\*============================================================================*/
/*******************************************************************************
*                            Standard BSD IP features                          *
*******************************************************************************/
#ifndef AL_IP_BSD_H_
#define AL_IP_BSD_H_

#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#ifdef AL_HAVE_IPV6
#define AL_SOCKADDR_STORAGE_SIZE   sizeof(struct sockaddr_storage)
#define AL_SOCKADDR_DATA_SIZE     (sizeof(struct sockaddr_storage) - sizeof(short))
#else
#define AL_SOCKADDR_STORAGE_SIZE   sizeof(struct sockaddr)
#define AL_SOCKADDR_DATA_SIZE     (sizeof(struct sockaddr) - sizeof(short))
#endif

# define INVALID_SOCKET  (unsigned int)(~0)

typedef fd_set al_fd_set;

#define AL_FD_ZERO FD_ZERO
#define AL_FD_SET FD_SET
#define AL_FD_ISSET FD_ISSET

#define AL_LITTLE_ENDIAN

#endif /*AL_IP_BSD_H_*/
