/*============================================================================*\
|                                                                              |
|                          SOA4D Abstraction Layer                             |
|                                                                              |
|               ->>  Copyright 2008 Schneider Electric SA <<-                  |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1.5 $
|                     $Date: 2008/02/06 18:02:25 $
\*============================================================================*/
/*******************************************************************************
*                           Win32 socket features                              *
*******************************************************************************/
#ifndef AL_IP_WINSOCK_H_
#define AL_IP_WINSOCK_H_

#include <io.h>
#include <fcntl.h>

// #include <winsock2.h> // must be included in al_target.h because of order
#include <Ws2tcpip.h>

#ifdef AL_HAVE_IPV6
#define AL_SOCKADDR_STORAGE_SIZE   sizeof(struct sockaddr_storage)
#define AL_SOCKADDR_DATA_SIZE     (sizeof(struct sockaddr_storage) - sizeof(short))
#else
#define AL_SOCKADDR_STORAGE_SIZE   sizeof(struct sockaddr)
#define AL_SOCKADDR_DATA_SIZE     (sizeof(struct sockaddr) - sizeof(short))
#endif

#define AL_LITTLE_ENDIAN

typedef	fd_set al_fd_set;

#define AL_FD_ZERO FD_ZERO
#define AL_FD_SET FD_SET
#define AL_FD_ISSET FD_ISSET


#endif /*AL_IP_WINSOCK_H_*/
