/*============================================================================*\
|                                                                              |
|                          SOA4D Abstraction Layer                             |
|                                                                              |
|               ->>  Copyright 2008 Schneider Electric SA <<-                  |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1.1 $
|                     $Date: 2008/01/04 18:02:44 $
\*============================================================================*/
/*******************************************************************************
*             AL RTOS features implementation for POSIX platforms              *
*******************************************************************************/
#ifndef AL_RTOS_POSIX_H_
#define AL_RTOS_POSIX_H_

#include <pthread.h>
#include <semaphore.h>

#define AL_HAVE_DATETIME

#define AL_NO_WAIT		(al_timestruct_t*)NULL
#define AL_WAIT_FOREVER	(al_timestruct_t*)0xFFFFFFFF

/*----------------------------------------------------------------------------*\
 *                              Thread management                             *
\*----------------------------------------------------------------------------*/
typedef pthread_t al_task_t;

/*----------------------------------------------------------------------------*\
 *                             Mutexes management                             *
\*----------------------------------------------------------------------------*/
typedef pthread_mutex_t al_mutex_t;

/*----------------------------------------------------------------------------*\
 *                            Semaphores management                           *
\*----------------------------------------------------------------------------*/
typedef sem_t al_sem_t;

/*----------------------------------------------------------------------------*\
 *                            Queue management                                *
\*----------------------------------------------------------------------------*/
// Not implemented
typedef int al_queue_t;

#endif /*AL_RTOS_POSIX_H_*/
