/*============================================================================*\
|                                                                              |
|                          SOA4D Abstraction Layer                             |
|                                                                              |
|               ->>  Copyright 2008 Schneider Electric SA <<-                  |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1.1 $
|                     $Date: 2008/01/03 18:01:18 $
\*============================================================================*/
/*******************************************************************************
*             AL RTOS features implementation for Win32 platforms              *
*******************************************************************************/
#ifndef AL_RTOS_WIN32_H_
#define AL_RTOS_WIN32_H_

#include "al_common.h"

#include <windows.h>
#include <time.h>
#include <sys/timeb.h>

#define AL_HAVE_DATETIME

#define AL_ENOMSG           -45 /* no message of desired type */
#define AL_OS_MSG_Q_FIFO	0

#define AL_NO_WAIT		(al_timestruct_t*)0x00000000
#define AL_WAIT_FOREVER	(al_timestruct_t*)0xFFFFFFFF

/*----------------------------------------------------------------------------*\
 *                              Thread management                             *
\*----------------------------------------------------------------------------*/
typedef HANDLE al_task_t;

/*----------------------------------------------------------------------------*\
 *                             Mutexes management                             *
\*----------------------------------------------------------------------------*/
typedef CRITICAL_SECTION al_mutex_t;

/*----------------------------------------------------------------------------*\
 *                            Semaphores management                           *
\*----------------------------------------------------------------------------*/
typedef HANDLE al_sem_t;

/*----------------------------------------------------------------------------*\
 *                            Queues management					              *
\*----------------------------------------------------------------------------*/
typedef struct
{
	HANDLE			ReadPipe;
	HANDLE			WritePipe;
	unsigned long	maxMsgLength;
}al_queue_t;

/*----------------------------------------------------------------------------*\
 *                            Timer management					              *
\*----------------------------------------------------------------------------*/
typedef int	al_timer;


#endif /*AL_RTOS_WIN32_H_*/
