/*============================================================================*\
|                                                                              |
|                          SOA4D DPWSCore Samples                              |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|                                                                              |
|        + File info:                                                          |
|                     $Revision: 2123 $
|                     $Date: 2009-02-26 18:58:13 +0100 (jeu, 26 fév 2009) $
\*============================================================================*/
/******************************************************************************\
 *                     Projector Static Service Class Loader                  *
\******************************************************************************/

#include "sscl_prj.h"

#include "prjStub.h" // Generated stub & skeleton include file for projector device implementation.
#include "prj.nsmap" // Generated namespace table include file for projector device implementation.

#include "dc/dc_Epx.h"	// XML streaming processing API
#include "fileio.h"	// File utility used for boot sequence & binary data persistence.

/* Service class loader callback declarations. */
int prj_new_service(short href_endpoint);
int prj_free_service(short href_endpoint);
int prj_serialize_impl(short href_sclass, void * szr_ctx);

/*
 *	Runtime data
 */

// Identifier for this service implementation (service class loader) used in the
// configuration file.
struct qname prj_iqn = {PRJ_NS, PRJ_ELT_SSCL_IMPL};

/* Callback associated to the previously defined qualified name.
   It will be called when the washer service class loader is loaded in order to
   initialize the various functions called when:
	+ a service of this class is created,
	+ a service of this class is deleted,
	+ the service class is to be serialized in XML for instance for configuration
	  backup,
	+ a request for a service is to be processed.
	See load_cbk reference for more information.
*/
int prj_load_cbk(short href_sclass, void * psr_ctx, dispatch_cbk * p_dispatch_cbk, struct scl_callbacks * p_cbks)
{
	/* Achieves implementation tag parsing with EPX (here very simple). Note that
	 * the current event is the 'implementation' start tag
	 */
	if (epx_next(psr_ctx) != EPX_EVT_END_ELEMENT || QNAME_NOT_EQUALS_WILDCARD(epx_get_ns_uri(psr_ctx), epx_get_lname(psr_ctx), PRJ_NS, PRJ_ELT_SSCL_IMPL))
		return DPWS_ERR_INCORRECT_IMPL_TAG;

	*p_dispatch_cbk = prj_serve_request;	// generated skeleton dispatch function.
	p_cbks->new_service = prj_new_service;	// service instance creation callback.
	p_cbks->free_service = prj_free_service;	// service instance deletion callback.
	p_cbks->serialize_impl = prj_serialize_impl;	// serialization callback
	return DPWS_OK;
}

/* Allows to initialize dimmer service runtime data on service creation. */
int prj_new_service(short href_endpoint)
{
	// No service data
	return DPWS_OK;
}

/* On service deletion the user data is freed using this callback. */
int prj_free_service(short href_endpoint)
{
	// No service data
	return DPWS_OK;
}

/* Service class implementation tag serialization callback. */
int prj_serialize_impl(short href_sclass, void * szr_ctx)
{
	epx_start_element(szr_ctx, PRJ_NS, PRJ_ELT_SSCL_IMPL);	// Here the whole tag must be generated using EPX
	epx_define_prefix(szr_ctx, PRJ_PREFIX, PRJ_NS);
	epx_end_element(szr_ctx, PRJ_NS, PRJ_ELT_SSCL_IMPL);
	return DPWS_OK;
}


/*
 *                   Service operations
 */

/* Receives and saves received file (supposed to be an image). */
int __prj__DisplayImage(struct dpws* dpws, struct prj__AttachmentType *prj__Image)
{
	printf("--> Requesting image display\n");
	if (writefile("MyImage.jpg", prj__Image->Param.__ptr, prj__Image->Param.__size) < 0) {
		printf("Cannot save attachment\n");
		return SOAP_OK;
	}
	printf("Attachment received and saved under MyImage.jpg (size: %d, type: %s)\n", prj__Image->Param.__size, prj__Image->Param.type);
	return DPWS_OK;
}
