/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|             ->>  Copyright 2008-2009 Schneider Electric SA <<-               |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 152 $
|                     $Date: 2007-10-09 17:22:05 +0200 (mar., 09 oct. 2007) $
\*============================================================================*/
/*******************************************************************************
*                  DPWSCore Network Adapter portability layer                  *
*******************************************************************************/
#include "dcDCPL_Net.h"

#include "al_net.h"	// must be before stdsoap2.h inclusion because of problem including several times windows.h & winsock2
#include "al_ip.h"

#include "dcDCPL_Socket.h"
#include "dcCOMN_Tools.h"

byte dcpl_mac_address[6];

/*------------------------- Static Functions prototypes ----------------------*/

static int itf_match(dc_ip_filter_t * filter, al_netif_info_t * netif);
static int addr_match(dc_ip_filter_t * filter, al_sockaddr_t * sockaddr);

/*----------------------------------------------------------------------------*/

static int itf_match(dc_ip_filter_t * filter, al_netif_info_t * netif)
{
	if (filter && filter->netif)
	{
		switch (filter->netif->filter_type)
		{
		case DC_NETIF_SELECT_NAME:
			return !strcmp(filter->netif->value.buf, netif->name);
		case DC_NETIF_SELECT_MAC:
			if (!parse_mac_address(dcpl_mac_address, filter->netif->value.buf))
				return 0;
			return !memcmp(dcpl_mac_address, netif->mac_address, 6);
		case DC_NETIF_SELECT_NUMBER:
			return filter->netif->value.itf_nb == netif->interface_selector;
		default:
			return 0;
		}
	}
	else
		return 1;
}

static int addr_match(dc_ip_filter_t * filter, al_sockaddr_t * sockaddr)
{
	int af = al_sockaddr_getDomain(sockaddr);
	if (filter)
	{
		if (filter->proto == DC_PROTO_ANY
			|| (filter->proto == DC_PROTO_INET && af == AF_INET)
#ifdef AL_HAVE_IPV6
			|| (filter->proto == DC_PROTO_INET6 && af == AF_INET6)
#endif
			)
		{

			al_ipNetAddr_t ip_addr;
			al_sockaddr_getNetAddr(sockaddr, &ip_addr);
			if (al_sockaddr_isLoopback(&ip_addr))
				return filter->include_loopback;
			else if (filter->nb_addrs > 0)
			{
				int i = 0;
				al_sockaddr_t filter_sa;
				al_ipNetAddr_t ipAddr, ipAddrFilter;

				for (; i < filter->nb_addrs; i++)
				{
					al_sockaddr_init(af, &filter_sa, sizeof(filter_sa));
					al_sockaddr_setNetAddrFromAddrStr(&filter_sa, filter->addrs[i]);
					al_sockaddr_getNetAddr(sockaddr, &ipAddr);	// Note: or use al_sockaddr_getNetAddrToAddrStr and strcmp
					al_sockaddr_getNetAddr(&filter_sa, &ipAddrFilter);
#ifdef AL_HAVE_IPV6

					if (!memcmp(&ipAddr.addr, &ipAddrFilter.addr, ipAddr.netAddrLen))	// struct comparison
#else
					if (ipAddr == ipAddrFilter)
#endif
						return 1;
				}
			}
			else
				return 1;
		}
	}
	else
		return 1;
	return 0;
}

int dcpl_retrieve_ip_info(dc_ip_filter_t * filter, dcpl_ip_addr_t ** result, int * result_nb)
{
	al_netif_info_t * netifs;
	int nb_netifs, i, j, mac_filled = 0;
	dcpl_ip_addr_t * wResult;

	if (al_get_netif_info(&netifs, &nb_netifs))
		return -1;

	/* First pass to count matching entries */
	*result_nb = 0;
	for (i = 0; i < nb_netifs; i++)
	{
		if (itf_match(filter, &netifs[i]))
		{
			for (j = 0; j < netifs[i].addr_nb; j++)
			{
				if (addr_match(filter, &netifs[i].addrs[j]))
					(*result_nb)++;
			}
		}
	}

	*result = dcpl_malloc(sizeof(dcpl_ip_addr_t) * (*result_nb));

	/* Fill results */
	wResult = *result;
	for (i = 0; i < nb_netifs; i++)
	{
		if (itf_match(filter, &netifs[i]))
		{
			if (!mac_filled)
				memcpy(dcpl_mac_address, netifs[i].mac_address, 6);

			for (j = 0; j < netifs[i].addr_nb; j++)
			{
				if (addr_match(filter, &netifs[i].addrs[j]))
				{
					al_ipNetAddr_t netAddr;

					switch(al_sockaddr_getDomain(&netifs[i].addrs[j]))
					{
					case AF_INET:
						al_sockaddr_getNetAddr(&netifs[i].addrs[j], &netAddr);
#ifdef AL_HAVE_IPV6
						wResult->ipv4_addr = netAddr.addr.netAddr4.addr;
						break;
					case AF_INET6:
						wResult->ipv4_addr = 0;
#else
						wResult->ipv4_addr = netAddr;
#endif
						break;
					}
					wResult->itf_nb = netifs[i].interface_selector;
					al_sockaddr_getNetAddrToAddrStr(&netifs[i].addrs[j], wResult->ip_address, AL_INET6_ADDRSTRLEN, 0);		/**< Absolute criterion */
					wResult++;
				}
			}
		}
	}
	al_release_netif_info();
	return DCPL_OK;
}

int dcpl_free_ip_info(dcpl_ip_addr_t * addrs, int nb_addrs)
{
	dcpl_free(addrs);
	return DCPL_OK;
}
