/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|             ->>  Copyright 2008-2009 Schneider Electric SA <<-               |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 152 $
|                     $Date: 2007-10-09 17:22:05 +0200 (mar., 09 oct. 2007) $
\*============================================================================*/
/*******************************************************************************
*                         DPWSCore OS portability layer                        *
*******************************************************************************/
#include "dcDCPL_Os.h"

#include "al_rtos.h"


/* static allocation */

static al_mutex_t mutexes[DC_LOCK_NB];
static int cur_mutex_idx = 0;

/*----------------------------------------------------------------------------*\
 *                              Clock management                              *
\*----------------------------------------------------------------------------*/

uint64_t dcpl_get_clock(void)
{
	al_timestruct_t t;
	return al_get_clock(&t) ? 0 : t.sec * 1000 + t.nsec / 1000000;
}

int dcpl_get_time(uint32_t * s, uint32_t * ns) // seconds since 00:00:00 GMT, January 1, 1970 or since boot according to platform features
{
	al_timestruct_t t;
#ifdef AL_HAVE_DATETIME
	if (al_get_posix_time(&t))
#else
	if (al_get_clock(&t))
#endif
		return -1;
	if (s)
		*s = t.sec;
	if (ns)
		*ns = t.nsec;
	return 0;
}

int dcpl_sleep(uint64_t dly)
{
	al_timestruct_t t;
	t.sec = (uint32_t)dly / 1000;
	t.nsec = (uint32_t)((dly % 1000) * 1000000);
	return al_sleep(&t) ? al_rtos_error() : 0;
}

/*----------------------------------------------------------------------------*\
 *                             Mutexes management                             *
\*----------------------------------------------------------------------------*/

dcpl_mutex_t * dcpl_mutex_init(void)
{
	al_mutex_t * t;
	if (cur_mutex_idx < DC_LOCK_NB)
		t = &mutexes[cur_mutex_idx++];
	else
		return NULL;
	return al_mutex_init(t, NULL) ? NULL : (dcpl_mutex_t *)t;
}

int dcpl_mutex_delete(dcpl_mutex_t *mutex)
{
	return al_mutex_delete((al_mutex_t *)mutex) ? al_rtos_error() : 0;
}

int dcpl_mutex_lock(dcpl_mutex_t *mutex)
{
	return al_mutex_lock((al_mutex_t *)mutex) ? al_rtos_error() : 0;
}

int dcpl_mutex_unlock(dcpl_mutex_t *mutex)
{
	return al_mutex_unlock((al_mutex_t *)mutex) ? al_rtos_error() : 0;
}

/*----------------------------------------------------------------------------*\
 *                             Process management                             *
\*----------------------------------------------------------------------------*/
uint32_t dcpl_process_id(void) { return al_get_pid();}
