### Common definitions ###
include $(DC_IBS_DIR)/common.def

### Default source list definition if not done by module ###
SRCS_C=$(notdir $(foreach dir,$(SRC_DIRS),$(wildcard $(dir)/*.c)))
SRCS_CPP=$(notdir $(foreach dir,$(SRC_DIRS),$(wildcard $(dir)/*.cpp)))
OBJS_C=$(SRCS_C:.c=.o)
OBJS_CPP=$(SRCS_CPP:.cpp=.o)
OBJS+=$(OBJS_C) $(OBJS_CPP)

ifneq ($(MAKECMDGOALS),distclean)
ifneq ($(MAKECMDGOALS),cleanall)
ifneq ($(MAKECMDGOALS),clean)
-include $(SRCS_C:.c=.d)
-include $(SRCS_CPP:.cpp=.d)
endif
endif
endif

.DEFAULT_GOAL=all

### Common targets ###
%.o: %.c
		$(CC) -c $(CPPFLAGS) $(CFLAGS) -o $@ $<

%.o: %.cpp
		$(CXX) -c $(CPPFLAGS) $(CFLAGS) -o $@ $<

$(MAKE_STATIC_DEPS): %.mak:
		$(MAKE) -C $(DC_TARGET_DIR)/$*/$(DC_ARCH) static
			
%.d: %.c
		$(SHELL) -ec '$(CC) -MM -MG $(CPPFLAGS) $(CIFLAGS) $< \
			| sed '\''s/\($*\)\.o[ :]*/\1.o $@ : /g'\'' > $@; \
			[ -s $@ ] || rm -f $@'

%.d: %.cpp
		$(SHELL) -ec '$(CXX) -MM -MG $(CPPFLAGS) $(CIFLAGS) $< \
			| sed '\''s/\($*\)\.o[ :]*/\1.o $@ : /g'\'' > $@; \
			[ -s $@ ] || rm -f $@'

cleanall: clean
		-rm *.d
