# generation specific
SOAPCPP_SC=gsoap-soapcpp-2.7.6
SOAPCPP_TC_DIR=$(DC_IBS_DIR)/$(DC_BUILD_TARGET)/$(SOAPCPP_SC)/$(DC_BUILD_ARCH)
SOAPCPP=$(SOAPCPP_TC_DIR)/$(DC_$(SOAPCPP_SC)_TC)$(EXE_EXT)
SOAPCPP_FLAGS=-I$(DC_TOOLS_DIR)/$(SOAPCPP_SC)/import:$(VPATH)
WSDL2H_SC=gsoap-wsdl2h-2.7.6
WSDL2H_TC_DIR=$(DC_IBS_DIR)/$(DC_BUILD_TARGET)/$(WSDL2H_SC)/$(DC_BUILD_ARCH)
WSDL2H=$(WSDL2H_TC_DIR)/$(DC_$(WSDL2H_SC)_TC)$(EXE_EXT)

# call common makefile after generation definitions so that are available for dependency include (else they are pruned)
DC_SRC_ROOT?=$(DC_APPS_DIR)
DC_IBS_DIR?=../../../../gnu
include $(DC_IBS_DIR)/common.mk

CUSTOM_OUTPUT_FILES+= *.c *.h *.nsmap *.gsoap *.xml
LDFLAGS+= $(CUSTOM_EXE_OPTIONS)

.PHONY: all exe clean cleanall distclean prerequisites
		
exe: prerequisites $(DC_TC)$(EXE_EXT)

prerequisites: $(MAKE_STATIC_DEPS) $(MAKE_SHARED_DEPS)
		
$(DC_TC)$(EXE_EXT): $(OBJS) $(STATIC_DEPS) $(SHARED_DEPS)
		$(LINKER) $(CMFLAGS) -o $(DC_TC)$(EXE_EXT) $(OBJS) $(LDFLAGS) $(LIBS)

%Stub.h %C.c %ClientLib.c %ServerLib.c %HandlerLib.c %.nsmap: %.gsoap $(SOAPCPP)
		$(SOAPCPP) $(SOAPCPP_FLAGS) -2ucn -p$* $<

%.gsoap: typemap.dat %.wsdl $(WSDL2H)
		$(WSDL2H) -o $@ -c -t $< $(filter %.wsdl, $^)
		
$(MAKE_SHARED_DEPS): %.mak:
		$(MAKE) -C $(DC_TARGET_DIR)/$*/$(DC_ARCH) shared
		$(INSTALL_SHARED_DEP)

$(SOAPCPP):
		$(MAKE) -C $(SOAPCPP_TC_DIR) all

$(WSDL2H):
		$(MAKE) -C $(WSDL2H_TC_DIR) all

clean:
		-rm *.o $(DC_TC)$(EXE_EXT) $(EXE_OUTPUT_FILES) $(CUSTOM_OUTPUT_FILES)

distclean: cleanall $(CLEAN_DEPS)
		
$(CLEAN_DEPS): %.clean:
		$(MAKE) -C $(DC_TARGET_DIR)/$*/$(DC_ARCH) distclean
