/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* Common C data types used by DPWSCore
* This header is included from everywhere. This is why it performs the optional
* dc_config.h inclusion (unleashed by DC_USER_CONFIG) so the user could set all
* definitions that can enable or disable some stacks features like DPWS_DEBUG
* or allow to plug optional software like a custom allocator.
*******************************************************************************/

#ifndef CTYPES_H_
#define CTYPES_H_

#include "stdint.h"
#include "time.h"

#ifdef DC_USER_CONFIG
# include "dc_config.h"		// include user DPWSCore stack configuration
#else	// default stack configuration
# define WITH_WSMAN
#endif

/** Boolean type */
#ifndef DC_BOOL
# define DC_BOOL int
# define DC_TRUE 1	/**< True boolean value */
# define DC_FALSE 0	/**< False boolean value */
#endif

/** byte definition used for MAC addresses */
typedef unsigned char   byte;

/** Make uint32_t with 2 uint16_t
 * @param hi High weight 16 bit integer
 * @param lo Low weight 16 bit integer
 * @param[out] dest Destination 32 bit integer
 */
#define MAKE_32b(hi, lo, dest) {dest = hi&0x7FFF; dest = dest<<16; dest += lo&0x7FFF;}

#endif /*CTYPES_H_*/
