/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2072 $
|                     $Date: 2009-02-11 12:11:36 +0100 (mer., 11 févr. 2009) $
\*============================================================================*/

#ifndef DCCOMN_MEM_H_
#define DCCOMN_MEM_H_

/*----------------------------------------------------------------------------*\
 *                       Allocation redirection macros                        *
\*----------------------------------------------------------------------------*/
#include "dcDCPL_Mem.h"

/** Memory categories : defines the modules that allocates the memory or the
 * usage when the module is unknown.
 */
enum dc_mem_cat {
	DC_MEM_NETWORK = 0,	/**< Network interface manager */
	DC_MEM_REGISTRY = 1,	/**< DPWS device registry */
	DC_MEM_CACHE = 2,	/**< Discovery cache */
	DC_MEM_DISCOVERY = 3,	/**< WS-Discovery messages scheduling information */
	DC_MEM_CONN_POOL = 4,	/**< Connection pool */
	DC_MEM_SUBSCRIPTION	= 5,	/**< Eventing subscription management */
	DC_MEM_CONF_MANAGER	= 6,	/**< XML Configuration/dynamic deployment manager */
	DC_MEM_TRANSIENT = 7,	/**< Temporary allocation using standard allocator. e.g. spaw resolve, multi-filter lookup... */
	DC_MEM_GSOAP = 8,	/**< soap_malloc or gSOAP runtime (so stub & skeleton allocation) **/
	DC_MEM_API = 10,	/**< Allocation returned to the user through the API */
	DC_MEM_WSMAN = 11,	/**< WS-Management protocol */
	DC_MEM_DYNDEPL = 12,	/**< Dynamic deployment descriptor */
	DC_MEM_MSG_PROCESSING = 13,	/**< Message processing. Example: SOAP headers */
	DC_MEM_UNKNOWN = 14,	/**< Unknown module: for instance when a multi-purpose utility needs allocation */
	DC_MEM_ALL = 15	/**< Wildcard category for external tool wanting to designate all categories */
};

#ifndef DC_MALLOC
/** Default allocation macro.
 * @param mod A \a enum dc_mem_cat value identifying the caller.
 * @param size The number or bytes to allocate.
 * @return The allocated buffer.
 */
# define DC_MALLOC(mod, size) dcpl_malloc(size)
#endif

#ifndef DC_STRDUP
/** String duplicator that uses the default allocator.
 * @param mod A \a enum dc_mem_cat value identifying the caller.
 * @param s The string to copy.
 * @return The duplicate string.
 */
# define DC_STRDUP(mod, s) (s ? dcpl_strdup(s) : NULL)
#endif

#ifndef DC_FREE
/** Default allocator memory free macro.
 * @param mod A \a enum dc_mem_cat value identifying the caller.
 * @param ptr The buffer to free.
 */
# define DC_FREE(mod, ptr) dcpl_free(ptr)
#endif

#endif /* DCCOMN_MEM_H_ */
