/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

 /*
  **
  ** To anyone who acknowledges that this file is provided "AS IS"
  ** without any express or implied warranty: permission to use, copy,
  ** modify, and distribute this file for any purpose is hereby
  ** granted without fee, provided that the above copyright notices and
  ** this notice appears in all source code copies, and that none of
  ** the names of Open Software Foundation, Inc., Hewlett-Packard
  ** Company, or Digital Equipment Corporation be used in advertising
  ** or publicity pertaining to distribution of the software without
  ** specific, written prior permission.  Neither Open Software
  ** Foundation, Inc., Hewlett-Packard Company, nor Digital Equipment
  ** Corporation makes any representations about the suitability of
  ** this software for any purpose.
  */
#ifndef UUID_H_
#define UUID_H_

#include "dc/dc_Types.h"
#include "dcDCPL_Os.h"

/** \file dcCOMN_Uuid.h
 *   UUID Generator. Not protected against concurrent access.
 * Copyright (c) 1990- 1993, 1996 Open Software Foundation, Inc.
 * Copyright (c) 1989 by Hewlett-Packard Company, Palo Alto, Ca. &
 * Digital Equipment Corporation, Maynard, Mass.
*/

/*----------------------------------------------------------------------------*\
 *                               UUID generator                               *
\*----------------------------------------------------------------------------*/
#define UUID_SCHEME_SIZE			9
#define UUID_SCHEME					"urn:uuid:"
#define UUID_SIZE					36
#ifndef SCHEME_UUID_STRING_SIZE		// is used by the public API but this file is not public, so duplication
# define SCHEME_UUID_STRING_SIZE		46
#endif
#ifndef UUID_STRING_SIZE		// is used by the public API but this file is not public, so duplication
# define UUID_STRING_SIZE				37
#endif

/** Startup initialization routine for the UUID module.
 * Initialize the random generator.
 */
void uuid_init();

/** The random number generation function used for UUID generation.
 * @return A random unsigned integer.
 */
uint16_t true_random(void);


/** Generates an UUID basing on MAC address, time and process ID.
 * @param[out] uuid The destination buffer for the generated UUID. Must be at
 * least UUID_STRING_SIZE long.
 * @param mac_addr A 6 byte buffer containing a MAC address (supposed to be
 * unique)
 * @return A pointer on the filled buffer.
 */
char * uuid_create(char * uuid, byte * mac_addr);

/** Generates an UUID basing on MAC address and a provided numeric ID.
 * @param[out] uuid The destination buffer for the generated UUID. Must be at
 * least UUID_STRING_SIZE long.
 * @param instance A numeric value used for controlled diversification.
 * @param mac_addr A 6 byte buffer containing a MAC address (supposed to be
 * unique)
 * @return A pointer on the filled buffer.
 */
char * stable_uuid_create(char * uuid, uint32_t instance, byte * mac_addr);


/** Format a string UUID into an URI that is to say it ensures the string starts
 * with "urn:uuid:".
 * @param[out] buffer This buffer must be at last least SCHEME_UUID_STRING_SIZE
 * bytes long
 * @param uuid The original uuid string
 * @return A pointer on the filled buffer.
  */
char * format_scheme_uuid(char buffer[SCHEME_UUID_STRING_SIZE], char *uuid);

#endif /*UUID_H_*/
