/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/******************************************************************************\
 *                                SHARED TOOLS                                *
\******************************************************************************/

#include "dcCOMN_Tools.h"
#include "dcCOMN_Uuid.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/*----------------------------------------------------------------------------*\
 *                                  XML UTILITIES                             *
\*----------------------------------------------------------------------------*/

#define DAY_IN_YEAR (365)	// NOTE: average value
#define DAY_IN_MONTH (30)	// NOTE: average value
#define HOUR_IN_DAY (24)
#define SEC_IN_HOUR (3600)
#define MIN_IN_HOUR (60)
#define SEC_IN_MIN (60)

// NOTE: alter the input string, does not control overflow
int32_t xmlduration2duration(char *p)
{
    int32_t d = 0;
    char *t = NULL, *del = "-PYMDTHMS.", buf[10];
    int minus = 0, p_found = 0, t_found = 0;
    int f = 0;
    for (;*p;p++)
    {
        if (*p >= '0' && *p <= '9')
        {
            if (!p_found)	// datetime or invalid duration
                return 0;
            if (!t)
                t = p;
        }
        else
        {
            while (*del != *p)
            {
                del++;
                if (!del)
                    return 0;
            }
            // delimitor found
            switch (*p)
            {
            case '-':
                minus = 1;
                break;
            case 'P':
                p_found = 1;
                break;
            case 'T':
                t_found = 1;
                break;
            case '.':
				p++;
            	// NOTE: ignore second decimals
            	while (*p && *p != 'S') {
            		if (*p < '0' || *p > '9')
            			return 0;
            		p++;
            	}
                //*(p + 1) = '\0';
                //break;
            case 'Y':
            case 'D':
            case 'H':
            case 'M':
            case 'S':
                if (!t)
                    return 0;
                strncpy(buf, t, p - t);
                buf[p - t] = '\0';
                switch (*p)
                {
                case 'Y':
                    f = DAY_IN_YEAR * HOUR_IN_DAY * SEC_IN_HOUR;	// NOTE: could avoid some multiplications
                    break;
                case 'D':
                    f = HOUR_IN_DAY * SEC_IN_HOUR;
                    break;
                case 'H':
                    f = SEC_IN_HOUR;
                    break;
                case 'M':	// trick: month or minute
                    if (t_found)
                        f = SEC_IN_MIN;
                    else
                        f = DAY_IN_MONTH * HOUR_IN_DAY * SEC_IN_HOUR;
                    break;
                case 'S':
                    f = 1;
                    break;
                }
                d +=  atoi(buf) * f;
                break;
            default:
                return 0;
            }
            t = NULL;
        }
    }

    return minus ? -d : d;
}

char * duration2xmlduration(char *dest, int32_t duration)
{
    long d;
    short h, m;
    char * minus = "";
    if (duration < 0)
    {
        minus = "-";
        duration = -duration;
    }
    d = (long)(duration / (HOUR_IN_DAY * SEC_IN_HOUR));
    duration = duration % (HOUR_IN_DAY * SEC_IN_HOUR);
    h = (short)(duration / SEC_IN_HOUR);
    duration = duration % SEC_IN_HOUR;
    m = (short)(duration / SEC_IN_MIN);
    duration = duration % SEC_IN_MIN;
    if (d > 0)
        sprintf(dest, "%sP%ldDT%dH%dM%dS", minus, d, h, m, (int)duration);
    else if (h > 0)
        sprintf(dest, "%sPT%dH%dM%dS", minus, h, m, (int)duration);
    else if (m > 0)
        sprintf(dest, "%sPT%dM%dS", minus, m, (int)duration);
    else
        sprintf(dest, "%sPT%dS", minus, (int)duration);
    return dest;
}

/*----------------------------------------------------------------------------*\
 *                                  COMPARISONS                               *
\*----------------------------------------------------------------------------*/

#define is_delim(c) (!(c) || (c) == '/' || (c) == '?' || (c) == '#')

DC_BOOL rfc2396_match(char *s1, char *s2)
{
	// compare scheme
    if (s1 == NULL || s2 == NULL)
        return s1 == s2;
    while (*s1 && *s2 && *s1 != ':')
    {
        if (tolower(*s1) != tolower(*s2))
            return DC_FALSE;
        s1++;
        s2++;
    }
	if (*s1 != ':' || *s2 != ':')
		return DC_FALSE;
    s1++;
    s2++;
    // compare host name and paths
    do
    {
		while (!is_delim(*s1))
        {
			if (!*s2 || tolower(*s1) != tolower(*s2)
                    || (*s1 == '.' && (*(s1 + 1) == '.' || *(s1 + 1) == '/'))	// do not match with . or .. segments
                    || (*s2 == '.' && (*(s2 + 1) == '.' || *(s2 + 1) == '/')))
                return DC_FALSE;
            s1++;
            s2++;
        }
		// Starting a new S1 segment (a final '/' is ignored)
		if (*s1 == '/' && *(s1+1)) {
			if (*s2 != '/') return DC_FALSE;
			s1++;
			s2++;
		} else { // S1 is terminated
			return is_delim(*s2) ? DC_TRUE : DC_FALSE;
		}
    } while (*s2);
    return DC_FALSE;
}

/*----------------------------------------------------------------------------*\
 *                                  NETWORKING                                *
\*----------------------------------------------------------------------------*/
#define MAKE_BYTE(hi, lo) ((hi<<4)|lo)

/* Hexa/ASCII conversion */
static const char FIG_OFFSET = '0';
static const char FIG_MAX = '9';
static const char UPPERCASE_OFFSET = 'A';
static const char UPPERCASE_MAX = 'F';
static const char LOWERCASE_OFFSET = 'a';
static const char LOWERCASE_MAX = 'f';
static const char SEPARATOR_1 = '-';
static const char SEPARATOR_2 = ':';


#define CHAR_HEXA2VALUE(c) (c >= FIG_OFFSET && c <= FIG_MAX ? c - FIG_OFFSET \
		:(c >= UPPERCASE_OFFSET && c <= UPPERCASE_MAX ? c - UPPERCASE_OFFSET + 10 \
		:(c >= LOWERCASE_OFFSET && c <= LOWERCASE_MAX ? c - LOWERCASE_OFFSET + 10 : -1)))


byte* parse_mac_address(byte * mac_addr, const char * mac)
{
    int i = 0;

    do
    {
    	if (!*mac || !*(mac+1))
    		break;
        mac_addr[i] = MAKE_BYTE(CHAR_HEXA2VALUE(*mac), CHAR_HEXA2VALUE(*(mac+1)));
        if (*(mac+2) == SEPARATOR_1 || *(mac+2) == SEPARATOR_2)
            mac += 3;
        else
            mac += 2;
        i++;
    }
    while (i < 6);
    return i < 6 ? NULL : mac_addr;
}

const char * is_physical_address(const char * addr)
{
    if (!strncmp(addr, "http:", 5))
    	return addr + 5;
    else if (!strncmp(addr, "https:", 6))
		return addr + 6;
    else
    	return NULL;
}

