/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1578 $
|                     $Date: 2008-08-06 10:24:29 +0200 (mer., 06 août 2008) $
\*============================================================================*/

/***************************************************************************//**
* \file
* DPWSCore Memory Allocation portability layer.
*******************************************************************************/

#ifndef DCPL_MEM_H_
#define DCPL_MEM_H_

/** Memory allocation function provided by the platform.
 * @param size The required memory space.
 * @return A memory buffer or NULL if no memory is available
 */
void * dcpl_malloc(size_t size);

/** Memory liberation function provided by the platform.
 * @param ptr The buffer to free.
 */
void dcpl_free(void * ptr);

/** Creates a "copy" string buffer.
 * @param s The original string to copy.
 * @return The copy.
 */
char * dcpl_strdup(const char *s);


#endif /*DCPL_MEM_H_*/
