/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1174 $
|                     $Date: 2008-05-28 09:48:51 +0200 (mer., 28 mai 2008) $
\*============================================================================*/

/***************************************************************************//**
* \file
* DPWSCore Network Adapter Information Access portability layer.
*******************************************************************************/

#ifndef DCPL_NET_H_
#define DCPL_NET_H_

#include "dc/dc_Types.h"
#include "stdint.h"


/** Result structure that contains retrieved network interface IP information.
 * This flat table format has been chosen for compactness must be ordered
 * by itf_nb.
 */
typedef struct dcpl_ip_addr {
	uint32_t itf_nb;		/**< The interface index specified for IPv6. If IPv6 is not supported, the implementation may use an arbitrary numbering. */
	char ip_address[46];	/**< The string form of the IP address */
	uint32_t ipv4_addr;		/**< NULL if IPv6 (can be used to retrieve the address family). This is used to set the multicast IPv4 interface contrary to IPv6 that uses the interface index. */
} dcpl_ip_addr_t;

/** Retrieves the address family for an IP address entry */
#define DCPL_GET_ADDR_FAMILY(a) ((a)->ipv4_addr ? DCPL_AF_INET : DCPL_AF_INET6)

/** Tests if an IP address entry is IP V4 */
#define DCPL_ADDR_IS_IPV4(a) ((a)->ipv4_addr)

/** Retrieves the interface index to use for multicast selection for an IP
 * address entry.
 */
#define DCPL_GET_MULTICAST_NETIF_INDEX(a) ((a)->ipv4_addr ? (a)->ipv4_addr : (a)->itf_nb)

/** To fill with any interface MAC address.
 * Used for UUID generation.
 */
extern byte dcpl_mac_address[6];


#ifdef __cplusplus
extern "C" {
#endif

/** Retrieves network interface IP information from the system.
 * This function is expected to be called once by the caller except if
 * \a dcpl_free_ip_info has been called since (no required re-entrancy).
 * @param filter A filter reducing the number or IP addresses retrieved. If
 * NULL, no filtering should be done and all addresses retrieved.
 * @param[out] result An array of IP addresses ordered by interface.
 * results ordered by itf_nb. The memory allocation is managed by the
 * implementation.
 * @param[out] result_nb The size of the return \a result array.
 * @return DCPL_OK in cased of success, DCPL_NOT_SUPPORTED_ERROR if the
 * asked filtering is not supported or not relevant for the platform.
 */
int dcpl_retrieve_ip_info(dc_ip_filter_t * filter, dcpl_ip_addr_t ** result, int * result_nb);

/** Free memory for the results returned by \a dcpl_retrieve_ip_info.
 * @param addrs The array to free.
 * @param nb_addrs The size of the provided \a addrs array.
 * @return A DCPL error code.
 */
int dcpl_free_ip_info(dcpl_ip_addr_t * addrs, int nb_addrs);

#ifdef __cplusplus
}
#endif

#endif /*DCPL_NET_H_*/
