/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 820 $
|                     $Date: 2008-03-13 14:17:02 +0100 (jeu., 13 mars 2008) $
\*============================================================================*/

/** \page advanced Advanced features
 * Let's quote:
 * <ul>
 * <li>TCP Connection pooling (dc_ConnPool.h must be included),</li>
 * <li>External HTTP server plugin (see dc_DpwsRequest.h),</li>
 * <li>WS-Management plugin (see dc_WsMan.h, dc_Plugin.h and dc_WsmanTypes.h),</li>
 * </ul>
 */

/***************************************************************************//**
* \file
* TCP connection pooling API.
* Its use allows avoiding:
* <ul>
* <li>Connection overhead.</li>
* <li>exhaustion due to the TIME_WAIT problem.</li>
* </ul>
*******************************************************************************/

#ifndef CONNPOOL_H
#define CONNPOOL_H

#include "dc/dc_Dpws.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Initialize the client-side connection pool.
 * @param max_size The maximum number of pooled connections. Default to 10.
 * @param max_idle_time The number of seconds after which an idle connection will be closed. Default to 10 s.
 * @return DPWS_OK on success, SOAP_EOM if the pool could not be allocated.
 */
DC_RT_FMAC1 int dpws_init_connection_pool(int max_size, int max_idle_time);

/** Activate/deactivate connection pooling for a DPWS context.
* @param dpws The DPWS context.
* @param on DC_TRUE to activate, DC_FALSE to disable.
* @return DPWS_OK on success.
*/
DC_RT_FMAC1 int dpws_use_connection_pool(struct dpws* dpws, DC_BOOL on);

/** Close all pooled connections, including those in use.
* @return DPWS_OK on success.
*/
DC_RT_FMAC1 int dpws_shutdown_connection_pool();

#ifdef __cplusplus
}
#endif

#endif

