/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* This plug-in interface is dedicated to the implementation of a custom
* WS-Eventing subscription manager.
* This API has been specifically designed for an external WS-Management
* implementation.
*******************************************************************************/

#ifndef PLUGIN_H_
#define PLUGIN_H_

#include "dc/dc_Types.h"

#ifndef DC_RT_FMAC1	/* runtime functions declaration prefix */
# define DC_RT_FMAC1
#endif

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
* \name Utilities
* @{
*******************************************************************************/

/** Generates a random UUID into a provided buffer.
 * @param uuid The buffer which length must be SCHEME_UUID_STRING_SIZE (46) at
 * least.
 * @return A pointer on the provided buffer.
 */
DC_RT_FMAC1 char * dpws_schemed_uuid_create(char *uuid);	// DPWS lib exported utility

// @}

/***************************************************************************//**
* \name WS-Eventing subscription manager plugin
* @{
*******************************************************************************/

/** Eventing subscription manager plugin definition.
 */
struct wse_sm_plugin {

	/** Create subscription hook.
	 * @param dpws A pointer on a dpws runtime data structure.
	 * @param duration The requested duration for the subscription (in seconds).
	 * Note that the duration has been put a ceiling according to the registry
	 * settings.
	 * @param filter An URI array containing the actions that are concerned by
	 * the subscription.
	 * @param filter_size The size of the preceding filter array.
	 * @param notify_to The EPR that should receive the notification.
	 * @param end_to The EPR that should receive the notification end (may
	 * not be used since the condition to send it may not be known by the
	 * implementor.)
	 * @param[out] uuid An UUID for the subscription in its text form (using hex encoding).
	 * If data is not persistent, it should be allocated on the gSOAP heap.
	 * @return DPWS_OK or an error code.
	 */
	int (*create_subsc)(
		struct dpws * dpws,
		uint32_t duration,
		char ** filter,
		int filter_size,
		struct wsa_endpoint_ref * notify_to,
		struct wsa_endpoint_ref * end_to,
		char ** uuid
	);
	/** Renew subscription hook.
	 * @param dpws A pointer on a dpws runtime data structure.
	 * @param subsc_id The UUID of the subscription.
	 * @param duration The requested duration for the subscription (in seconds).
	 * Note that the duration has been but a ceiling according to the registry
	 * settings.
	 * @return DPWS_OK or an error code.
	 */
	int (*renew_subsc)(struct dpws * dpws, char * subsc_id, uint32_t duration);
	/** Retrieves the remaining duration for a subscription.
	 * @param dpws A pointer on a dpws runtime data structure.
	 * @param subsc_id The UUID of the subscription.
	 * @param[out] The remaining duration in seconds for the subscription.
	 * @return DPWS_OK or an error code.
	 */
	int (*subsc_status)(struct dpws * dpws, char * subsc_id, uint32_t * duration);
	/** Delete subscription hook.
	 * @param dpws A pointer on a dpws runtime data structure.
	 * @param subsc_id The UUID of the subscription.
	 * @return DPWS_OK or an error code.
	 */
	int (*delete_subsc)(struct dpws*, char *);
};

// @}

#ifdef __cplusplus
}
#endif

#endif /*PLUGIN_H_*/
