/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/*******************************************************************************
*         DPWS/WS-MetadataExchange/WS-Transfer Protocol Implementation         *
*******************************************************************************/
#ifndef METADATA_H
# define METADATA_H

# include "dcCOMN_Tools.h"
# include "dcDPWS_Cache.h"

#ifdef SOAP_FMAC3
# undef SOAP_FMAC3
#endif
#define SOAP_FMAC3 static
# include "transferStub.h"
# include "metadataStub.h"

extern struct Namespace dpws10_transfer_snd_namespaces[];	/**< WS-Transfer sGOAP "send" namespace table for DPWS 1.0 */
extern struct Namespace dpws11_transfer_snd_namespaces[];	/**< WS-Transfer sGOAP "send" namespace table for DPWS 1.1 */

/** Client stub for retrieving device or service metadata (GET).
 * @param dpws The DPWS runtime structure.
 * @param href A device or service cache proxy handle reference.
 * @param device The cache device structure for cache update in case hosting
 * information is available in the response. If NULL, no cache update is
 * performed.
 * @param model If provided and \a href points to a device proxy, will be filled
 * with DPWS "this_model" metadata.
 * @param model If provided and \a href points to a device proxy, will be filled
 * with DPWS "this_device" metadata.
 * @param host_endpoints A dynamic array of EPRs that will receive the host EPRS
 * from the "relationship" section.
 * @param services A dynamic array of structures that will receive the "hosted"
 * part from the "relationship" section.
 * @param wsdlList A dynamic array of structures that will receive the "WSDL"
 * section.
 * @return A DPWS error code.
 */
int get_endpoint_metadata(
						struct dpws* dpws, short href,
						struct device_proxy * device,
						struct model_info *model,
						struct device_info *dev_info,
						DA_TYPED(pepr)* host_endpoints,
						DA_TYPED(psi)* services,
						DA_TYPED(pwi)* wsdlList
						);
#endif
