/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1863 $
|                     $Date: 2008-11-24 15:00:53 +0100 (lun., 24 nov. 2008) $
\*============================================================================*/

/*******************************************************************************
*                         Network Interface Manager                            *
*******************************************************************************/
#ifndef DCDPWS_NETWORK_H_
#define DCDPWS_NETWORK_H_

#include "dcDCPL_Net.h"
#include "dcDCPL_Socket.h"	// for protocol bit-flags definition

// Network interface configuration

extern dcpl_ip_addr_t * dc_netif_addrs;	/**< IP address list from DCPL_Net */
extern int dc_netif_nb_addrs;	/**< The size of the \a dc_netif_addrs table */
extern char * dc_hostname;	/**< The local host name given by the API user. Potentially NULL. */
extern int dc_network_mode; /**< The IP network supported selected for the toolkit. A combination of DCPL_AF_INET & DCPL_AF_INET6 bit flags */

/** Retrieves network information from DCPL_Net.
 * Initializes all the global variables owned by this module.
 * @param filter The filter given by the user when initializing the stack.
 * @param hostname This nullable parameter will be used instead of IP address
 * for transport addresses publication.
 * @param mono_netif If DC_TRUE, the module will use only the first interface
 * retrieved in order to ensure backwards toolkit compatibility.
 * @return A DPWS error code.
 */
int init_network(dc_ip_filter_t * filter, const char * hostname, DC_BOOL mono_netif);

/** Releases network information got from DCPL_Net.
 */
void uninit_network();

// Utilities for network interfaces browsing.

typedef int (*network_addr_cbk)(dcpl_ip_addr_t * netif_addr, void * cbk_data);

/** Calls the callback once by required protocol for each interface.
 * @param protocols A filter combination of DCPL_AF_INET & DCPL_AF_INET6 bit
 * flags.
 * @param cbk The callback called for every interface.
 * @param cbk_data Callback user data.
 * @return A DPWS error code.
 */
int network_browse_interfaces(int protocols, network_addr_cbk cbk, void * cbk_data);

/** Count interfaces considering each protocol as a different interface.
 * @param protocols A combination of DCPL_AF_INET & DCPL_AF_INET6 bit flags.
 * @return The number of interfaces/protocols.
 */
int network_count_interfaces(int protocols);

/** Calls the callback for all addresses of a given interface.
 * @param itf_nb The index of the interface.
 * @param protocols A filter combination of DCPL_AF_INET & DCPL_AF_INET6 bit
 * flags.
 * @param cbk The callback called for every interface.
 * @param cbk_data Callback user data.
 * @return A DPWS error code.
 */
int network_browse_interface(uint32_t itf_nb, int protocols, network_addr_cbk cbk, void * cbk_data);

/** Function that loops on dcpl_tcp_connect using all local interfaces when the
 * host is a link-local IPv6 address and the scope is not specified in host.
 * @param host The host IP address.
 * @param port The destination TCP port.
 * @param timeout The timeout in ms for the whole operation.
 * @param data Socket data used for the connection.
 * @param error A DCPL error structure.
 * @return A DCPL socket identifier.
 */
DCPL_SOCKET network_tcp_connect(const char *host, uint16_t port, int timeout, struct socket_data * data, struct dcpl_error * error);

#endif /* DCDPWS_NETWORK_H_ */
