/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/
/*******************************************************************************
*                             SUBSCRIPTION MANAGER                             *
*******************************************************************************/

#ifndef SUBSCMANAGER_H
# define SUBSCMANAGER_H

/*----------------------------------------------------------------------------*\
*   WS-Eventing Protocol Implementation (for subscription manager port type)  *
\*----------------------------------------------------------------------------*/
# include "dc/dc_Dpws.h"
# ifdef SOAP_FMAC3
#  undef SOAP_FMAC3
# endif
# define SOAP_FMAC3 static
# include "subscmanagerStub.h"
# include "dcCOMN_DynArray.h"
# include "dcDCPL_Os.h"

/** Public exposition of "subscription manager" message serialization for SOAP
 * fault details enhancement with incoming message parts.
 * @param dpws The message context.
 * @param A pointer on the C structure to be serialized.
 * @param tag The tag name.
 * @param type The XML type Id used by the gSOAP marshalling generated code.
 * @return A DPWS error code.
 */
int subscManager_putelement(struct dpws *dpws, const void *ptr, const char *tag, int type);

/* PLUGIN API implementation */

/** @see \a "dc/dc_Plugin.h" */
int wse_create_subsc_manager(struct dpws * dpws, uint32_t expiration, char ** filter, int filter_size,
			struct wsa_endpoint_ref * notify_to, struct wsa_endpoint_ref * end_to, char ** uuid);
/** @see \a "dc/dc_Plugin.h" */
int wse_renew_subsc(struct dpws * dpws, char * subsc_id, uint32_t duration);
/** @see \a "dc/dc_Plugin.h" */
int wse_subsc_status(struct dpws * dpws, char * subsc_id, uint32_t * duration);
/** @see \a "dc/dc_Plugin.h" */
int wse_delete_subscription(struct dpws* dpws, char * id);

/*----------------------------------------------------------------------------*\
 *                              CONFIGURATION API                             *
\*----------------------------------------------------------------------------*/
/** Sets an attribute value on the subscription manager.
 * @param att The attribute numeric identifier.
 * @param value The value to set.
 * @param reset If true, the current value will wil erased and replaced. If
 * false and multi-valued, the value is added to the list.
 * @return A DPWS error code.
 */
int set_subsc_manager_config_ptr_att(int att, const void * value, DC_BOOL reset);

/** Get the value of an integer attribute of the subscription manager.
 * @param att The attribute numeric identifier.
 * @param index The index of the attribute if multivalued or 0 else.
 * @return The retrieved value.
 */
unsigned long get_subsc_manager_config_int_att(int att, int index);

/** Get number of values for a subscription manager attribute.
 * @param att The attribute numeric identifier.
 * @return The number of attribute values.
 */
int get_subsc_manager_config_att_count(int att);

/*----------------------------------------------------------------------------*\
 *                                 MODULE API                                 *
\*----------------------------------------------------------------------------*/

extern dcpl_mutex_t * subsc_manager_lock;	/**< Module lock. */
extern struct dc_subsc_config sm_config;	/**< Module configuration. */

/** Configuration structure for the subscription manager */
struct dc_subsc_config {
	uint16_t		max_subsc_nb;	/**< Maximum number of subscriptions. */
	uint32_t		max_subsc_duration;	/**< The maximum duration a subscription can be granted in seconds. */
};

/** The subscription node structure. */
struct event_subscription {
	char id[SCHEME_UUID_STRING_SIZE];	/**< The subscription ID used as the primary identifier. An UUID which prefix is stored to make serialization more efficient */
	char * address;	/**< Subscription address that identifies the manager for the event sink. */
	struct wsa_endpoint_ref * notify_to;	/**< Event sink EPR. */
	struct wsa_endpoint_ref * end_to;	/**< The EPR to send "event end" notification. Optional. */
	DA_TYPED(str) actions;	/**< The action filter for the subscription */
	uint32_t expiration;	/**< The date of the expiration in seconds since 00:00:00 GMT, January 1, 1970 or since boot according to platform features */
	struct event_subscription * next;	/**< Next node in the chained list. */
};

/** The subscription manager structure.
 * It holds for a service a list of subscriptions.
 */
struct subscription_manager {
	short hrefService;	/**< The handle of the service for which the subsciption manager was created. */
	struct event_subscription * subscriptions;	/**< The list of running or expired subscriptions. */
};

/** Initialize subscription managers structures.
 * @return A DPWS error code.
 */
int init_subsc_managers();

/** Cleans subscription managers structures.
 */
void uninit_subsc_managers();

/** Delete a subscription manager owned by a service.
 * @param hrefService The owner service handle reference.
 */
void delete_subsc_manager(short hrefService);

/** Changes a subscription manager owner service handle reference.
 * @param hrefService The current owner service handle reference.
 * @param hrefService The new owner service handle reference.
 * @return A DPWS error code.
 */
int clone_subsc_manager(short hrefService, short hrefClone);

/** Structure that will be passed as a callback data for sending "eventing end"
 * messages.
 */
struct end_info {
	struct dpws * dpws;	/**< The DPWS runtime structure to send messages. */
	struct _wse__SubscriptionEnd *pBody;	/**< The "eventing end" message body. */
};

/** Function that will send "eventing end" messages for a given hosted service
 * and it associated subscription manager.
 * Has a dynamic array browse callback prototype so that to be used for browsing
 * hosted services of a device.
 * @param hrefService The handle of the service for which subscription ends in
 * an unexpected way.
 * @param eventEndInfo Callback data needed to send messages.
 */
DC_BOOL send_eventing_end_msg(short * hrefService, struct end_info *eventEndInfo);


#endif
