/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1772 $
|                     $Date: 2008-10-09 11:57:03 +0200 (jeu., 09 oct. 2008) $
\*============================================================================*/

#ifndef DCDPWS_TRANSPORT_H_
#define DCDPWS_TRANSPORT_H_

#include "dcDCPL_Socket.h"

#define DC_TRANSPORT_UDP_TYPE 1
#define DC_TRANSPORT_HTTP_TYPE 2

#define DC_TRANSPORT_UNKNOWN	0x00
#define DC_TRANSPORT_ALLOCED	0x01
#define DC_TRANSPORT_INTERNAL	0x02
#define DC_TRANSPORT_INPUT		0x04
#define DC_TRANSPORT_OUTPUT		0x08
#define DC_TRANSPORT_POOLED		0x10

#define MAX_IP_ADDRESS_STRING_LEN 46

struct dpws;
struct transport_data;
struct media_type;

typedef struct transport_class {
	// Server-side: "Inherited" from struct transport_fns
	int (*fsend)(struct dpws * dpws, void* tdata, const char * buf, size_t buflen);
	int (*frecv)(struct dpws * dpws, void* tdata, char * buf, size_t buflen);
	int (*fresponse)(struct dpws * dpws, void* tdata, int status, struct media_type * mtype, size_t len);
	// End Server-side
	// Client-side
	int (*fconnect)(struct dpws * dpws, const char * endpoint, const char * action, struct media_type * mtype, size_t len);
	int (*frecvemptyresponse)(struct dpws * dpws);
	int (*fclose)(struct dpws * dpws);
	// End client-side
	// Transport-specific life cycle functions
	int (*fcleardata)(struct transport_data * tdata);
	int (*fsetupchannel)(struct dpws * dpws, struct transport_data * tdata);
	int (*fteardownchannel)(struct dpws * dpws, struct transport_data * tdata);
	int (*fclosechannel)(struct transport_data * tdata);
	// End transport-specific
} transport_class_t;

typedef struct transport_data {
	struct transport_class * tclass;
	uint32_t status;
	DCPL_SOCKET socket;
	char peer_addr[MAX_IP_ADDRESS_STRING_LEN];
	unsigned short peer_port;
	uint32_t itf;
	struct dcpl_error error;
} transport_data_t;

transport_data_t * dc_transport_data_init(transport_data_t * tdata, size_t size, transport_class_t * tclass);
void dc_transport_data_clear(transport_data_t * tdata);
int dc_transport_setup_channel(struct dpws * dpws, transport_data_t * tdata, DCPL_SOCKET socket, uint32_t direction);
int dc_transport_teardown_channel(struct dpws * dpws, transport_data_t * tdata);
int dc_transport_close_channel(struct dpws * dpws);

#endif
