/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

#ifndef UTILS_H
# define UTILS_H

#include "dcDPWS_Dpws.h"
#include "dcCOMN_DynArray.h"

/*----------------------------------------------------------------------------*\
 *                                SCOPE UTILITIES                             *
\*----------------------------------------------------------------------------*/

scope_match_rule_t parse_match_rule(struct dpws * dpws, char *uri);
char * scope_match_string(struct dpws * dpws, scope_match_rule_t match_rule);

typedef DC_BOOL (*type_compare_cbk) (void *, void *);
DC_BOOL probe_match(dyn_array_t * types, DA_TYPED(str) * scopes, scope_match_rule_t match_rule,
	dyn_array_t *dev_types, DA_TYPED(str) *dev_scopes, da_cmp_cbk type_compare);

/*----------------------------------------------------------------------------*\
 *                                 COPY UTILITIES                             *
\*----------------------------------------------------------------------------*/

/* WSA EPRs */
struct wsa_endpoint_ref * endpoint_ref_dup(struct dpws* dpws, struct wsa_endpoint_ref * src);

/*----------------------------------------------------------------------------*\
 *                             CUSTOM XML MARSHALLING                         *
\*----------------------------------------------------------------------------*/

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_qname_list(struct soap* soap, struct dynamic_array *const* a);
SOAP_FMAC1 void SOAP_FMAC2 soap_default_qname_list(struct soap* soap, struct dynamic_array ** a);
SOAP_FMAC1 int SOAP_FMAC2 soap_out_qname_list(struct soap* soap, const char * tag, int id, struct dynamic_array *const* a, const char * type);
SOAP_FMAC1 struct dynamic_array ** SOAP_FMAC2 soap_in_qname_list(struct soap* soap, const char* tag, struct dynamic_array **a, const char* type);
SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_uri_list(struct soap* soap, struct dynamic_array *const* a);
SOAP_FMAC1 void SOAP_FMAC2 soap_default_uri_list(struct soap* soap, struct dynamic_array ** a);
SOAP_FMAC1 int SOAP_FMAC2 soap_out_uri_list(struct soap* soap, const char * tag, int id, struct dynamic_array *const* a, const char * type);
SOAP_FMAC1 struct dynamic_array ** SOAP_FMAC2 soap_in_uri_list(struct soap* soap, const char* tag, struct dynamic_array **a, const char* type);
SOAP_FMAC1 int SOAP_FMAC2 wsa_simple_element_in(struct dpws *dpws, const char *tag, char** value);
SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_endpoint_ref(struct soap* soap, struct wsa_endpoint_ref *const*a);
SOAP_FMAC1 void SOAP_FMAC2 soap_default_endpoint_ref(struct soap* soap, struct wsa_endpoint_ref **a);
SOAP_FMAC1 int SOAP_FMAC2 soap_out_endpoint_ref(struct soap *soap, const char *tag, int id, struct wsa_endpoint_ref *const*a, const char *type);
SOAP_FMAC1 struct wsa_endpoint_ref ** SOAP_FMAC2 soap_in_endpoint_ref(struct soap *soap, const char *tag, struct wsa_endpoint_ref **a, const char *type);

/** Look for a localized entry in an array.
 * The preferred lang one if found then the one without @lang (default), then in
 * english (first of the 3).
 * @param entries An array of XML localized string.
 * @param entry_nb The number of entries on the \a entries array.
 * @param preferred_lang The preferred language.
 * @return The found string.
 */
char* find_localized_entry(struct localized_string ** entries, int entry_nb, char *preferred_lang);

/*----------------------------------------------------------------------------*\
 *                           DATA CONSISTENCY TOOLS                           *
\*----------------------------------------------------------------------------*/

#ifdef DC_API_PARAM_CONTROL

DC_BOOL check_discovery_filter(discovery_filter_t * filter);

#endif

#endif
