/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/******************************************************************************\
 *                  Dynamic deployment server implementation                  *
\******************************************************************************/

#ifndef DYNDEPL_SERVER_H_
#define DYNDEPL_SERVER_H_

#include "dc/dc_Dpws.h"
#include "dc/dc_GenericInvocation.h"
#include "dc/dc_XMLConfiguration.h"

/*----------------------------------------------------------------------------*\
 *                           WS-Management constants                          *
\*----------------------------------------------------------------------------*/
// resource
#define WSMAN_ERR_INVALID_RESOURCE				1	// subcode : wsa:DestinationUnreachable
// selectors
#define WSMAN_ERR_INSUFFICIENT_SELECTORS		2	// subcode : wsman:InvalidSelectors
#define WSMAN_ERR_SELECTOR_TYPE_MISMATCH		3	// subcode : wsman:InvalidSelectors
#define WSMAN_ERR_INVALID_SELECTOR_VALUE		4	// subcode : wsman:InvalidSelectors
#define WSMAN_ERR_UNEXPECTED_SELECTORS			5	// subcode : wsman:InvalidSelectors
#define WSMAN_ERR_DUPLICATE_SELECTORS			6	// subcode : wsman:InvalidSelectors
// other
#define WSMAN_ERR_INTERNAL_ERROR				7	// subcode : wsman:InternalError
#define WSMAN_ERR_SCHEMA_VALIDATION_ERROR		8	// subcode : wsman:InternalError
#define WSMAN_ERR_CONCURRENCY					9	// subcode : wsman:InternalError
// create & put
#define WSMAN_ERR_INVALID_VALUES				10	// subcode : wst:InvalidRepresentation
#define WSMAN_ERR_MISSING_VALUES				11	// subcode : wst:InvalidRepresentation
#define WSMAN_ERR_INVALID_NAMESPACES			12	// subcode : wst:InvalidRepresentation
// create
#define WSMAN_ERR_ALREADY_EXISTS				13	// subcode : wsman:AlreadyExists
// fragment-level
#define WSMAN_ERR_UNSUPPORTED_FRAGMENT_ACCESS	14	// subcode : wsman:UnsupportedFeature
#define WSMAN_ERR_INVALID_FRAGMENT				15	// subcode : wst:InvalidRepresentation

#define WSMAN_FAULT_SC_INVALID_SELECTORS		"wsman:InvalidSelectors"
#define WSMAN_FAULT_SC_INTERNAL_ERROR			"wsman:InternalError"
#define WSMAN_FAULT_SC_INVALID_REPRESENTATION	"wst:InvalidRepresentation"
#define WSMAN_FAULT_SC_ALREADY_EXISTS			"wsman:AlreadyExists"
#define WSMAN_FAULT_SC_UNSUPPORTED_FEATURE		"wsman:UnsupportedFeature"
#define WSMAN_FAULT_SC_SCHEMA_VALIDATION_ERROR	"wsman:SchemaValidationError"
#define WSMAN_FAULT_SC_CONCURRENCY				"wsman:Concurrency"

#define WSMAN_FAULT_DETAIL_INVALID_RESOURCE				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidResourceURI"
#define WSMAN_FAULT_DETAIL_INSUFFICIENT_SELECTORS		"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InsufficientSelectors"
#define WSMAN_FAULT_DETAIL_TYPE_MISMATCH				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/TypeMismatch"
#define WSMAN_FAULT_DETAIL_INVALID_VALUE				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidValue"
#define WSMAN_FAULT_DETAIL_UNEXPECTED_SELECTORS			"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/UnexpectedSelectors"
#define WSMAN_FAULT_DETAIL_DUPLICATE_SELECTORS			"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/DuplicateSelectors"
#define WSMAN_FAULT_DETAIL_INVALID_VALUES				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidValues"
#define WSMAN_FAULT_DETAIL_MISSING_VALUES				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/MissingValues"
#define WSMAN_FAULT_DETAIL_INVALID_NAMESPACES			"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidNamespace"
#define WSMAN_FAULT_DETAIL_FRAGMENT_LEVEL_ACCESS		"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/FragmentLevelAccess"
#define WSMAN_FAULT_DETAIL_INVALID_FRAGMENT				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidFragment"

/*----------------------------------------------------------------------------*\
 *                      Management Service implementation                     *
\*----------------------------------------------------------------------------*/
/** @see "dc/dc_GenericInvocation.h" */
int dyndepl_serve_get(struct dpws * dpws, void * parsing_context, serialize_cbk * response_cbk, void ** p_user_data);
int dyndepl_serve_put(struct dpws * dpws, void * parsing_context, serialize_cbk * response_cbk, void ** p_user_data);
int dyndepl_serve_create(struct dpws * dpws, void * parsing_context, serialize_cbk * response_cbk, void ** p_user_data);
int dyndepl_serve_delete(struct dpws * dpws, void * parsing_context, serialize_cbk * response_cbk, void ** p_user_data);

#endif /*DYNDEPL_SERVER_H_*/
