/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* Dynamic Deployment client API.
* This API is a helper that uses the generic stub feature to invoke the
* dynamic deployment service without the burden to provide protocol informations
* like WS-Management headers and operation actions. This also makes clear what
* subset of the WS-Management is implemented and thus usable.
*******************************************************************************/

#ifndef WSMAN_CLIENT_H_
#define WSMAN_CLIENT_H_

#include "dc/dc_GenericInvocation.h"

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
* \name Get APIs
* WS-Transfer "Get" calls.
* @{
*******************************************************************************/

/**	Get description for a remote device through an invocation of the dynamic
 * deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. device descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_get_device(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data);

/**	Get description for a remote device types (WS-Discovery) through an
 * invocation of the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. device types descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_get_device_types(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data);

/**	Get description for a remote device scopes (WS-Discovery) through an
 * invocation of the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. device scopes descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_get_device_scopes(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data);

/**	Get description for a remote device "ThisDevice" metadata (WS-MetadataExchange)
 * through an invocation of the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. "ThisDevice" descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_get_this_device(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data);

/**	Get description for a remote device "ThisModel" metadata (WS-MetadataExchange)
 * through an invocation of the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. "ThisModel" descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_get_this_model(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data);

/**	Get description for a remote service class through an invocation of the
 * dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param sclass_id The service class ID for which information must be retrieved.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. service class descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_get_service_class(struct dpws *dpws, short href_dyndepl_service_proxy, char * sclass_id, parser_cbk response_cbk, void * user_data);

/**	Get description for a remote service  through an invocation of the dynamic
 * deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The UUID of the device hosting the target service.
 * @param service_id The service ID for which information must be retrieved.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. service descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_get_service(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, char * service_id, parser_cbk response_cbk, void * user_data);

// @}

/***************************************************************************//**
* \name Put APIs
* WS-Transfer "Put" calls.
* @{
*******************************************************************************/

/**	Overwrite descriptor for a remote device through an invocation of the
 * dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param request_cbk A generic skeleton callback for producing request content,
 * i.e. new device descriptor.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. updated device descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_put_device(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);

/**	Overwrite descriptor for a remote device types through an invocation of the
 * dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param request_cbk A generic skeleton callback for producing request content,
 * i.e. new device types descriptor.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. updated device types descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_put_device_types(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);

/**	Overwrite descriptor for a remote device scopes through an invocation of the
 * dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param request_cbk A generic skeleton callback for producing request content,
 * i.e. new device scopes descriptor.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. updated device scopes descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_put_device_scopes(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);

/**	Overwrite descriptor for a remote device "ThisDevice" metadata section
 * through an invocation of the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param request_cbk A generic skeleton callback for producing request content,
 * i.e. new "ThisDevice" descriptor.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. updated "ThisDevice" descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_put_this_device(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);

/**	Overwrite descriptor for a remote device "ThisModel" metadata section
 * through an invocation of the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The device UUID for which information must be retrieved.
 * @param request_cbk A generic skeleton callback for producing request content,
 * i.e. new "ThisModel" descriptor.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. updated "ThisModel" descriptor.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_put_this_model(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);

// @}

/***************************************************************************//**
* \name Create APIs
* WS-Transfer "Create" calls.
* @{
*******************************************************************************/

/**	Creates a new remote device using the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param request_cbk A generic skeleton callback for producing request content,
 * i.e. new device descriptor.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. created resource information.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_create_device(struct dpws *dpws, short href_dyndepl_service_proxy, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);

/**	Creates a new remote service class using the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param request_cbk A generic skeleton callback for producing request content,
 * i.e. new service class descriptor.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. created resource information.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_create_service_class(struct dpws *dpws, short href_dyndepl_service_proxy, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);

/**	Creates a new remote service using the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The UUID of the device that will host the new service.
 * @param request_cbk A generic skeleton callback for producing request content,
 * i.e. new service descriptor.
 * @param response_cbk A generic skeleton callback for response processing,
 * i.e. created resource information.
 * @param user_data Data that will be passed to message callback.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_create_service(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);

// @}

/***************************************************************************//**
* \name Delete APIs
* WS-Transfer "Delete" calls.
* @{
*******************************************************************************/

/**	Deletes a remote device using the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The UUID of the device to delete.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_delete_device(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid);

/**	Deletes a remote service class using the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param sclass_id The ID of the service class to delete.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_delete_service_class(struct dpws *dpws, short href_dyndepl_service_proxy, char * sclass_id);


/**	Deletes a remote service using the dynamic deployment service.
 * @param dpws A pointer on a dpws data structure used to process the request.
 * @param href_dyndepl_service_proxy The handle reference of the dynamic
 * deployment service proxy.
 * @param device_uuid The UUID of the device that hosts the service.
 * @param service_id The ID of the service to delete.
 * @return DPWS_OK, if no communication error occurred. Indeed, the user has to
 * check that the received response is not a fault. A DPWS or gSOAP error code
 * otherwise.
 */
DC_RT_FMAC1 int dyndepl_delete_service(struct dpws *dpws, short href_dyndepl_service_proxy, char * device_uuid, char * service_id);

// @}

#ifdef __cplusplus
}
#endif

#endif /*WSMAN_CLIENT_H_*/
