/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/
/******************************************************************************\
 *                         Dynamic deployment client                          *
\******************************************************************************/
#include "dc/dc_DyndeplClient.h"
#include "dc/dc_DyndeplConstants.h"
#include "dc/dc_WsManConstants.h"
#include "dcXCONF_Definitions.h"
#include "dcCOMN_Tools.h"

/*----------------------------------- Types ----------------------------------*/

#define NB_PREFIXES 1

/*----------------------------------- Data -----------------------------------*/

static struct prefix_def ns_tab[] = {{DYNDEPL_NS_PREFIX, DYNDEPL_NS_URI}};

/*------------------------- Static Functions prototypes ----------------------*/

static struct wsa_endpoint_ref * get_device_epr(struct dpws *dpws, short href_proxy, char * device_uuid, struct wsman_selector * sel);
static int call_device(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);
static int call_device_types(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);
static int call_device_scopes(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);
static int call_this_device(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);
static int call_this_model(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);
static int call_service_class(struct dpws *dpws, short href_proxy, char * action, char * sclass_id, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);
static int call_service(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, char * service_id, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);
static int delete_response_cbk (void * parser_context, struct dpws *dpws);

/*----------------------------------------------------------------------------*\
 *                                  Get APIs                                  *
\*----------------------------------------------------------------------------*/
static struct wsa_endpoint_ref * get_device_epr(struct dpws *dpws, short href_proxy, char * device_uuid, struct wsman_selector * sel)
{
	struct wsa_endpoint_ref * epr = dpws_get_default_endpoint_ref(dpws, href_proxy);
	epr->wsman_params.resource_uri = DYNDEPL_RESOURCE_DEVICE;
	epr->wsman_params.nb_selectors = 1;
	epr->wsman_params.selectors = sel;
	sel->name = DYNDEPL_SELECTOR_DEVICE;
	sel->value = device_uuid;
    return epr;
}

static int call_device(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsman_selector sel;
    return dpws_call(dpws, get_device_epr(dpws, href_proxy, device_uuid, &sel),
    		action, NULL, 0, request_cbk, response_cbk, user_data);
}

static int call_device_types(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsman_selector sel;
	struct xpath_expression f = {0, NULL, "dd:Types"};
	struct wsa_endpoint_ref * epr = get_device_epr(dpws, href_proxy, device_uuid, &sel);
	dpws->wsman_headers.fragment_transfer = &f;
    return dpws_call(dpws, epr, action, ns_tab, NB_PREFIXES, request_cbk, response_cbk, user_data);
}

static int call_device_scopes(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsman_selector sel;
	struct xpath_expression f = {0, NULL, "dd:Scopes"};
	struct wsa_endpoint_ref * epr = get_device_epr(dpws, href_proxy, device_uuid, &sel);
	dpws->wsman_headers.fragment_transfer = &f;
    return dpws_call(dpws, epr, action, ns_tab, NB_PREFIXES, request_cbk, response_cbk, user_data);
}

static int call_this_device(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsman_selector sel;
	struct xpath_expression f = {0, NULL, "dd:ThisDevice"};
	struct wsa_endpoint_ref * epr = get_device_epr(dpws, href_proxy, device_uuid, &sel);
	dpws->wsman_headers.fragment_transfer = &f;
    return dpws_call(dpws, epr, action, ns_tab, NB_PREFIXES, request_cbk, response_cbk, user_data);
}

static int call_this_model(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsman_selector sel;
	struct xpath_expression f = {0, NULL, "dd:ThisModel"};
	struct wsa_endpoint_ref * epr = get_device_epr(dpws, href_proxy, device_uuid, &sel);
	dpws->wsman_headers.fragment_transfer = &f;
    return dpws_call(dpws, epr, action, ns_tab, NB_PREFIXES, request_cbk, response_cbk, user_data);
}

static int call_service_class(struct dpws *dpws, short href_proxy, char * action, char * sclass_id, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsman_selector sel = {DYNDEPL_SELECTOR_SERVICE_CLASS, sclass_id};
	struct wsa_endpoint_ref * epr = dpws_get_default_endpoint_ref(dpws, href_proxy);
	epr->wsman_params.resource_uri = DYNDEPL_RESOURCE_SERVICE_CLASS;
	epr->wsman_params.nb_selectors = 1;
	epr->wsman_params.selectors = &sel;
    return dpws_call(dpws, epr, action, NULL, 0, request_cbk, response_cbk, user_data);
}

static int call_service(struct dpws *dpws, short href_proxy, char * action, char * device_uuid, char * service_id, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsman_selector sels[] = {{DYNDEPL_SELECTOR_DEVICE, device_uuid},{DYNDEPL_SELECTOR_SERVICE, service_id}};
	struct wsa_endpoint_ref * epr = dpws_get_default_endpoint_ref(dpws, href_proxy);
	epr->wsman_params.resource_uri = DYNDEPL_RESOURCE_SERVICE;
	epr->wsman_params.nb_selectors = 2;
	epr->wsman_params.selectors = sels;
    return dpws_call(dpws, epr, action, NULL, 0, request_cbk, response_cbk, user_data);
}

/*----------------------------------------------------------------------------*\
 *                                  Get APIs                                  *
\*----------------------------------------------------------------------------*/
int dyndepl_get_device(struct dpws *dpws, short href_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && response_cbk);
    return call_device(dpws, href_proxy, WSMAN_ACTION_GET, device_uuid, NULL, response_cbk, user_data);
}

int dyndepl_get_device_types(struct dpws *dpws, short href_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && response_cbk);
    return call_device_types(dpws, href_proxy, WSMAN_ACTION_GET, device_uuid, NULL, response_cbk, user_data);
}

int dyndepl_get_device_scopes(struct dpws *dpws, short href_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && response_cbk);
    return call_device_scopes(dpws, href_proxy, WSMAN_ACTION_GET, device_uuid, NULL, response_cbk, user_data);
}

int dyndepl_get_this_device(struct dpws *dpws, short href_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && response_cbk);
    return call_this_device(dpws, href_proxy, WSMAN_ACTION_GET, device_uuid, NULL, response_cbk, user_data);
}

int dyndepl_get_this_model(struct dpws *dpws, short href_proxy, char * device_uuid, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && response_cbk);
    return call_this_model(dpws, href_proxy, WSMAN_ACTION_GET, device_uuid, NULL, response_cbk, user_data);
}

int dyndepl_get_service_class(struct dpws *dpws, short href_proxy, char * sclass_id, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && sclass_id && response_cbk);
    return call_service_class(dpws, href_proxy, WSMAN_ACTION_GET, sclass_id, NULL, response_cbk, user_data);
}

int dyndepl_get_service(struct dpws *dpws, short href_proxy, char * device_uuid, char * service_id, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid	&& service_id && response_cbk);
    return call_service(dpws, href_proxy, WSMAN_ACTION_GET, device_uuid, service_id, NULL, response_cbk, user_data);
}

/*----------------------------------------------------------------------------*\
 *                                  Put APIs                                  *
\*----------------------------------------------------------------------------*/
int dyndepl_put_device(struct dpws *dpws, short href_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && request_cbk && response_cbk);
    return call_device(dpws, href_proxy, WSMAN_ACTION_PUT, device_uuid, request_cbk, response_cbk, user_data);
}

int dyndepl_put_device_types(struct dpws *dpws, short href_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && request_cbk && response_cbk);
    return call_device_types(dpws, href_proxy, WSMAN_ACTION_PUT, device_uuid, request_cbk, response_cbk, user_data);
}

int dyndepl_put_device_scopes(struct dpws *dpws, short href_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && request_cbk && response_cbk);
    return call_device_scopes(dpws, href_proxy, WSMAN_ACTION_PUT, device_uuid, request_cbk, response_cbk, user_data);
}

int dyndepl_put_this_device(struct dpws *dpws, short href_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && request_cbk && response_cbk);
    return call_this_device(dpws, href_proxy, WSMAN_ACTION_PUT, device_uuid, request_cbk, response_cbk, user_data);
}

int dyndepl_put_this_model(struct dpws *dpws, short href_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && request_cbk && response_cbk);
    return call_this_model(dpws, href_proxy, WSMAN_ACTION_PUT, device_uuid, request_cbk, response_cbk, user_data);
}

/*----------------------------------------------------------------------------*\
 *                                Create APIs                                 *
\*----------------------------------------------------------------------------*/
int dyndepl_create_device(struct dpws *dpws, short href_proxy, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsa_endpoint_ref * epr;

	DC_CHECK_PARAM(dpws && href_proxy >= 0 && request_cbk && response_cbk);

	epr = dpws_get_default_endpoint_ref(dpws, href_proxy);
	epr->wsman_params.resource_uri = DYNDEPL_RESOURCE_DEVICE;
    return dpws_call(dpws, epr, WSMAN_ACTION_CREATE, NULL, 0, request_cbk, response_cbk, user_data);
}

int dyndepl_create_service_class(struct dpws *dpws, short href_proxy, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsa_endpoint_ref * epr;

	DC_CHECK_PARAM(dpws && href_proxy >= 0 && request_cbk && response_cbk);

	epr = dpws_get_default_endpoint_ref(dpws, href_proxy);
	epr->wsman_params.resource_uri = DYNDEPL_RESOURCE_SERVICE_CLASS;
    return dpws_call(dpws, epr, WSMAN_ACTION_CREATE, NULL, 0, request_cbk, response_cbk, user_data);
}

int dyndepl_create_service(struct dpws *dpws, short href_proxy, char * device_uuid, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data)
{
	struct wsman_selector sel = {DYNDEPL_SELECTOR_DEVICE, device_uuid};
	struct wsa_endpoint_ref * epr;

	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && request_cbk && response_cbk);

	epr = dpws_get_default_endpoint_ref(dpws, href_proxy);
	epr->wsman_params.resource_uri = DYNDEPL_RESOURCE_SERVICE;
	epr->wsman_params.nb_selectors = 1;
	epr->wsman_params.selectors = &sel;
    return dpws_call(dpws, epr, WSMAN_ACTION_CREATE, NULL, 0, request_cbk, response_cbk, user_data);
}

/*----------------------------------------------------------------------------*\
 *                                Delete APIs                                 *
\*----------------------------------------------------------------------------*/
static int delete_response_cbk (void * parser_context, struct dpws *dpws)
{
	return strcmp(dpws->action, WSMAN_ACTION_DELETE_RESPONSE) ? SOAP_FAULT : SOAP_OK;
}

int dyndepl_delete_device(struct dpws *dpws, short href_proxy, char * device_uuid)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid);
    return call_device(dpws, href_proxy, WSMAN_ACTION_DELETE, device_uuid, NULL, (parser_cbk)delete_response_cbk, dpws);
}

int dyndepl_delete_service_class(struct dpws *dpws, short href_proxy, char * sclass_id)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && sclass_id);
    return call_service_class(dpws, href_proxy, WSMAN_ACTION_DELETE, sclass_id, NULL, (parser_cbk)delete_response_cbk, dpws);
}

int dyndepl_delete_service(struct dpws *dpws, short href_proxy, char * device_uuid, char * service_id)
{
	DC_CHECK_PARAM(dpws && href_proxy >= 0 && device_uuid && service_id);
    return call_service(dpws, href_proxy, WSMAN_ACTION_DELETE, device_uuid, service_id, NULL, (parser_cbk)delete_response_cbk, dpws);
}

