/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 957 $
|                     $Date: 2008-03-31 18:34:56 +0200 (lun., 31 mars 2008) $
\*============================================================================*/

/******************************************************************************\
 *                  WS-Management generic server implementation               *
\******************************************************************************/

#ifndef WSMAN_SERVER_H_
#define WSMAN_SERVER_H_

#include "dc/dc_Dpws.h"
#include "dc/dc_GenericInvocation.h"
#include "dc/dc_WsMan.h"

typedef struct wsman_handlers_list {
	struct wsman_resource_handler ** handlers;
	int handlers_count;
	struct wsman_resource_handler * default_handler;
} wsman_handlers_list_t;

typedef struct wsman_configuration_data {
	char* resource_uri;
	void* configuration_data;
} wsman_configuration_data_t;

typedef struct wsman_service_data {
	short href_service;
	struct wsman_handlers_list * handlers;
	struct wsman_configuration_data * configuration;
} wsman_service_data_t;

/*----------------------------------------------------------------------------*\
 *                           WS-Management constants                          *
\*----------------------------------------------------------------------------*/

#define WSMAN_SERVICE_ID "http://www.odonata.fr/services/Management"


#define WSMAN_FAULT_SC_INVALID_SELECTORS		"wsman:InvalidSelectors"
#define WSMAN_FAULT_SC_INTERNAL_ERROR			"wsman:InternalError"
#define WSMAN_FAULT_SC_INVALID_REPRESENTATION	"wst:InvalidRepresentation"
#define WSMAN_FAULT_SC_ALREADY_EXISTS			"wsman:AlreadyExists"
#define WSMAN_FAULT_SC_UNSUPPORTED_FEATURE		"wsman:UnsupportedFeature"
#define WSMAN_FAULT_SC_SCHEMA_VALIDATION_ERROR	"wsman:SchemaValidationError"
#define WSMAN_FAULT_SC_CONCURRENCY				"wsman:Concurrency"

#define WSMAN_FAULT_DETAIL_INVALID_RESOURCE				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidResourceURI"
#define WSMAN_FAULT_DETAIL_INSUFFICIENT_SELECTORS		"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InsufficientSelectors"
#define WSMAN_FAULT_DETAIL_TYPE_MISMATCH				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/TypeMismatch"
#define WSMAN_FAULT_DETAIL_INVALID_VALUE				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidValue"
#define WSMAN_FAULT_DETAIL_UNEXPECTED_SELECTORS			"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/UnexpectedSelectors"
#define WSMAN_FAULT_DETAIL_DUPLICATE_SELECTORS			"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/DuplicateSelectors"
#define WSMAN_FAULT_DETAIL_INVALID_VALUES				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidValues"
#define WSMAN_FAULT_DETAIL_MISSING_VALUES				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/MissingValues"
#define WSMAN_FAULT_DETAIL_INVALID_NAMESPACES			"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidNamespace"
#define WSMAN_FAULT_DETAIL_FRAGMENT_LEVEL_ACCESS		"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/FragmentLevelAccess"
#define WSMAN_FAULT_DETAIL_INVALID_FRAGMENT				"http://schemas.dmtf.org/wbem/wsman/1/wsman/faultDetail/InvalidFragment"

#endif /*WSMAN_SERVER_H_*/
