/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/******************************************************************************\
 *                       Dynamic deployment data manager                      *
\******************************************************************************/
#ifndef DYNDEPL_MGR_H_
#define DYNDEPL_MGR_H_

#include "dc/dc_XMLConfiguration.h"
#include "dc/dc_XMLTypes.h"
#include "dcXCONF_ReferenceManager.h"
#include "dcDCPL_Os.h"

extern dcpl_mutex_t * xmlconf_lock;

/*----------------------------------------------------------------------------*\
 *                               Type definitions                             *
\*----------------------------------------------------------------------------*/

DA_TYPED_DECL(de, struct dynload_entry);

extern DA_TYPED(de) loaders;

struct property_value {
	char * name;
	char * value;
};

DA_TYPED_DECL(wbr, struct ws_binding_ref);
DA_TYPED_DECL(pv, struct property_value);
DA_TYPED_DECL(ref, struct reference);
DA_TYPED_DECL(prop, struct property);

struct service_config {
	short href;
	struct service_class_config * class;	// This shortcut allow to be independent from the registry when cleaning (cleaning of services needs callbacks from the class)
	DA_TYPED(wbr) refs;
	DA_TYPED(pv) property_values;
};

struct property {
	struct reference p;	// optimization: uses the same parsing code.
	epx_boolean_t multiple;
	char * default_value;
};

struct service_class_config {
	short href;
	// interfaces stored in the registry conf except for the name (no used currently)
	DA_TYPED(ref) refs;
	DA_TYPED(prop) properties;
	//	wsdl stored in the registry
	// no need to store or return the implementation ?
	struct scl_callbacks cbks;
};

/*----------------------------------------------------------------------------*\
 *                          Dynamic Loader management                         *
\*----------------------------------------------------------------------------*/
void xconf_delete_loaders();

/*----------------------------------------------------------------------------*\
 *                       Service configuration management                     *
\*----------------------------------------------------------------------------*/
struct service_config * xconf_init_service();
int xconf_new_service(struct service_config * new_service);	// NOTE: allocated by the caller using xconf_init_service()
struct service_config * xconf_get_service(short href_service);	// NOTE: readonly
DC_BOOL xconf_delete_service(short href_service);
void xconf_delete_services();
void xconf_free_service(struct service_config * service);

/*----------------------------------------------------------------------------*\
 *                    Service class configuration management                  *
\*----------------------------------------------------------------------------*/
struct service_class_config * xconf_init_service_class();
/**
 * @param psr_ctx The parsing is passed with the current event being the implementation
 * element start event. The function is supposed to parse the whole element and manage
 * its content in order to be able to restore it when asked.
 */
int xconf_new_service_class(struct service_class_config * new_sclass, struct qname * impl_id, void * psr_ctx);	// NOTE: allocated by the caller using xconf_init_service_class()
struct service_class_config * xconf_get_service_class(short href_sclass);	// NOTE: readonly
DC_BOOL xconf_delete_service_class(short href_sclass);
void xconf_delete_service_classes();
void xconf_free_service_class(struct service_class_config * service_class);

/*----------------------------------------------------------------------------*\
 *                           Binding retrieval API                            *
\*----------------------------------------------------------------------------*/
struct reference * xconf_get_binding(short href_service, const char * name);
struct ws_binding_ref * xconf_get_binding_ref(short href_service, const char * name);

#endif /*DYNDEPL_MGR_H_*/
