/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/******************************************************************************\
 *                         Binding reference manager                          *
\******************************************************************************/
#include "dc/dc_Constants.h"
#include "dcCOMN_Tools.h"
#include "dcDCPL_Os.h"
#include "dcXCONF_ReferenceManager.h"
#include "dcXCONF_Manager.h"


/*------------------------- Static Functions prototypes ----------------------*/

static int lookup_binding_ref(struct dpws * dpws, short href_service, const char * name, struct wsa_endpoint_ref ** epr, DC_BOOL invalidate);

/*----------------------------------------------------------------------------*/

int dyndepl_discover_bref(struct dpws * dpws, struct ws_binding_ref * bref)
{
	int nbProxies, i = 0;
	short deviceProxy = -1, * deviceProxies, * serviceProxies;
	struct discovery_hint * d_hint;
	discovery_filter_t * filter;

	// Note: This conversion could be avoided if the structures were compatible. But how if dyn_array must not be exposed.
	if (!(filter = DC_MALLOC(DC_MEM_TRANSIENT, sizeof(discovery_filter_t) * bref->wsd_hints->hints.nb)))
		return DPWS_ERR_EOM;

	for (; i < bref->wsd_hints->hints.nb; i++)
	{
		d_hint = DA_GET(&bref->wsd_hints->hints, i);
		nbProxies = (bref->wsd_hints->on_multiple_matches == WSD_HINT_MM_ACTION_PICK_ONE ? 1 : 2);
		filter[i].types = (qname_t *)d_hint->types.tab;
		filter[i].nb_types = d_hint->types.nb;
		filter[i].scopes = (char **)d_hint->scopes.tab;
		filter[i].nb_scopes = d_hint->scopes.nb;
		filter[i].match_rule = WSD_MATCH_BY_UNSPECIFIED;
	}

	deviceProxies = dpws_lookup_ex(dpws, filter, bref->wsd_hints->hints.nb, &nbProxies, WSD_MATCH_TIMEOUT, WSD_LOOKUP_MODE_CACHE_FIRST);

	if (nbProxies > 0) {
		deviceProxy = deviceProxies[0];
		if (bref->wsd_hints->on_multiple_matches != WSD_HINT_MM_ACTION_PICK_ONE && nbProxies > 1)
		{	// MM fail
			dpws->err = DPWS_ERR_MULTIPLE_REFERENCE;
			goto exit;
		}
		nbProxies = 1;
		if (bref->wsd_hints->service_id)
			bref->proxy = dpws_get_service_by_id(dpws, deviceProxy, bref->wsd_hints->service_id);
		else {
			serviceProxies = dpws_get_services(
				dpws, deviceProxy, bref->sclass_ref->type.qname.ns,
				bref->sclass_ref->type.qname.lname, &nbProxies
			);
			if (serviceProxies)
				bref->proxy = *serviceProxies;
		}
		dpws_pin_proxy(bref->proxy);
		bref->epr = dpws_get_default_endpoint_ref(NULL, bref->proxy);
	}
exit:
	DC_FREE(DC_MEM_TRANSIENT, filter);
	dpws_end(dpws);
	if (!bref->epr)
	{
		switch (bref->wsd_hints->on_reference_lost)
		{
		case WSD_HINT_RL_ACTION_FAIL:
			return DPWS_ERR_COULD_NOT_BIND_FAIL;
		case WSD_HINT_RL_ACTION_RETRY:
			return DPWS_ERR_COULD_NOT_BIND_RETRY;
		case WSD_HINT_RL_ACTION_IGNORE:
			return DPWS_ERR_COULD_NOT_BIND_IGNORE;
		}
	}
	return DPWS_OK;
}

static int lookup_binding_ref(struct dpws * dpws, short href_service, const char * name, struct wsa_endpoint_ref ** epr, DC_BOOL invalidate)
{
	int ret = DPWS_OK;
	struct ws_binding_ref * bref;
	struct reference * ref;

	DC_CHECK_PARAM(dpws && href_service >= 0 && name && epr);

	bref = xconf_get_binding_ref(href_service, name);
	if (!bref) {
		// Check if the binding was optional or not
		ref = xconf_get_binding(href_service, name);
		if (ref)
			ret = ref->must_supply ? DPWS_ERR_MANDATORY_REF_MISSING : DPWS_ERR_OPTIONAL_REF_MISSING;
		else
			ret = DPWS_ERR_INVALID_PARAMETER;
		goto exit;
	}

	dcpl_mutex_lock(xmlconf_lock);	// protect access to EPR and proxy cache (only accessed by this function)
	if (invalidate) {
		if (bref->proxy) {
			dpws_invalidate_proxy(bref->proxy);
			bref->proxy = -1;
		}
		if (bref->wsd_hints) {
			dpws_endpoint_ref_free(bref->epr);
			bref->epr = NULL;
		}
		else
			ret = DPWS_ERR_STATIC_REFERENCE;
	}
	if (!bref->epr)	// nor static EPR, nor cached
		ret = dyndepl_discover_bref(dpws, bref);

	if (!ret)
		*epr = bref->epr;
	dcpl_mutex_unlock(xmlconf_lock);

exit:
	return ret;
}

DC_RT_FMAC1 int dpws_lookup_binding_ref(struct dpws * dpws, short href_service, const char * name, struct wsa_endpoint_ref ** epr)
{
	return lookup_binding_ref(dpws, href_service, name, epr, DC_FALSE);
}

DC_RT_FMAC1 int dpws_bind_reference(struct dpws * dpws, short href_service, const char * name, struct wsa_endpoint_ref ** epr)
{
	return lookup_binding_ref(dpws, href_service, name, epr, DC_TRUE);
}
