/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/******************************************************************************\
 *                              XML Configuration                             *
\******************************************************************************/
#include "dc/dc_XMLConfiguration.h"
#include "dc/dc_Constants.h"
#include "dc/dc_FileX.h"
#include "dcXCONF_Definitions.h"
#include "dcXCONF_Manager.h"
#include "dcDCPL_Os.h"
#include "dcXTOOL_SchemaParsing.h"
#include "dcCOMN_Tools.h"


/*----------------------------------------------------------------------------*\
 *                                General APIs                                *
\*----------------------------------------------------------------------------*/

DC_RT_FMAC1 int dpws_config_init()
{
	if ((xmlconf_lock = dcpl_mutex_init()) == NULL)
		return DPWS_ERR_CREATING_MUTEX;
	loaders.allocator = p_default_allocator;
	return DPWS_OK;
}

DC_RT_FMAC1 int dpws_config_shutdown()
{
	if (xmlconf_lock)
	{
		xconf_delete_services();
		xconf_delete_service_classes();
		xconf_delete_loaders();
		dcpl_mutex_delete(xmlconf_lock);
		xmlconf_lock = NULL;
	}
	return DPWS_OK;
}

/*----------------------------------------------------------------------------*\
 *                         XML Configuration persistency                      *
\*----------------------------------------------------------------------------*/
int dpws_sun_load_config(struct dpws * dpws, void * sun_in_stream)
{
	int ret = DPWS_OK, ret2;
    void * ctx;

	DC_CHECK_PARAM(dpws && sun_in_stream);

	if ((ret = xml_in_fopen(dpws_dpws2soap(dpws), sun_in_stream)))
		goto exit;

	ctx = epx_new_parser(NULL, dpws_dpws2soap(dpws));
	if (ctx)
		ret = dpws_load_config(ctx);
	else
		ret = DPWS_ERR_EOM;

exit:
	if (ctx)
		epx_delete_parser(ctx);
	ret2 = xml_in_fclose(dpws_dpws2soap(dpws));	// also calls soap_end()
	return ret ? ret : ret2;
}

int dpws_sun_save_config(struct dpws * dpws, void * sun_out_stream, DC_BOOL inc_boot_seq)
{
	int ret = DPWS_OK, ret2;
	void * ctx;

	DC_CHECK_PARAM(dpws && sun_out_stream);

	if ((ret = xml_out_fopen(dpws_dpws2soap(dpws), sun_out_stream)))
		goto exit;

	ctx = epx_new_serializer(NULL, dpws_dpws2soap(dpws));
	if (ctx)
		ret = dpws_save_config(ctx, inc_boot_seq, DC_FALSE);
	else
		ret = DPWS_ERR_EOM;

exit:
	if (ctx)
		epx_delete_serializer(ctx);
	ret2 = xml_out_fclose(dpws_dpws2soap(dpws));	// also calls soap_end()
	return ret ? ret : ret2;
}
