/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design;

import com.extjs.gxt.ui.client.XDOM;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.fx.Draggable;
import com.extjs.gxt.ui.client.util.Rectangle;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;

public class MyDraggable extends Draggable {

	protected static boolean inEvent = false;

	public MyDraggable(Component dragComponent, Component handle) {
		super(dragComponent, handle);
	}

	public MyDraggable(Component dragComponent) {
		super(dragComponent);
	}

	@Override
	protected void onMouseDown(ComponentEvent ce) {
		if (inEvent) {
			return;
		}
		inEvent = true;
		super.onMouseDown(ce);
	}

	@Override
	public void cancelDrag() {
		super.cancelDrag();
		removeProxy();
		inEvent = false;
	}

	@Override
	protected void stopDrag(Event event) {
		super.stopDrag(event);
		removeProxy();
		inEvent = false;
	}

	// public void reMakeProxy() {
	// addProxy();
	// proxyEl.setVisibility(true);
	// }
	//
	// public void hideProxy() {
	// if (proxyEl != null) {
	// proxyEl.setVisibility(false);
	// }
	// }

	public void addProxy() {
		if (proxyEl == null) {
			createProxy();
		}
		Element body = XDOM.getBody();
		if (DOM.getChildIndex(body, proxyEl.dom) == -1) {
			DOM.appendChild(body, proxyEl.dom);
			proxyEl.setVisibility(true);
			proxyEl.setStyleAttribute("zIndex", XDOM.getTopZIndex());
			proxyEl.makePositionable(true);
		}
	}

	public void removeProxy() {
		if (proxyEl != null) {
			// proxyEl.disableTextSelection(false);
			Element body = XDOM.getBody();
			if (DOM.getChildIndex(body, proxyEl.dom) != -1) {
				DOM.removeChild(body, proxyEl.dom);
			}
			// proxyEl = null;
		}
	}

	public Rectangle getStartBounds() {
		return this.startBounds;
	}

	public int getDragStartX() {
		return this.dragStartX;
	}

	public int getDragStartY() {
		return this.dragStartY;
	}

}
