/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.DesignPanel;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;

public class ButtonBarDelegate extends ContainerDelegate {

	private ButtonBar comp;

	protected String[] props = { "buttonWidth", "cellSpacing", "buttonAlign" };

	protected String[] innerProps = { "buttonWidth", "cellSpacing",
			"buttonAlign" };

	public ButtonBarDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (ButtonBar) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getButtonAlign".equals(mthodName)) {
			return comp.getButtonAlign();
		} else if ("getButtonPressed".equals(mthodName)) {
			return comp.getButtonPressed();
		} else if ("getButtonWidth".equals(mthodName)) {
			return comp.getButtonWidth();
		} else if ("getCellSpacing".equals(mthodName)) {
			return comp.getCellSpacing();
		} else if ("setButtonAlign".equals(mthodName)
				&& parms[0] instanceof HorizontalAlignment) {
			comp.setButtonAlign((HorizontalAlignment) parms[0]);
			return comp;
		} else if ("setButtonWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setButtonWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setCellSpacing".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setCellSpacing(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("add".equals(mthodName) && parms.length == 1
				&& parms[0] instanceof Button) {
			return comp.add((Button) parms[0]);
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof Button) {
			Button b = (Button) widget;
			if (comp.isRendered()) {
				Component parent = service.getParent();
				if (parent instanceof ContentPanel) {
					ContentPanel cp = (ContentPanel) parent;
					cp = GxtUtil.addButtonAfterRender(cp, b, insertIdx);
					insertIdx = -1;
				} else {
					GxtUtil.addAfterRender(comp, widget);
				}
			} else {
				if (insertIdx != -1) {
					comp.insert(b, insertIdx);
					insertIdx = -1;
				} else {
					comp.add(b);
				}
			}
		}
	}

	@Override
	public Component removeWidget(Component widget) {
		if (widget instanceof Button) {
			comp.remove((Button) widget);
		}
		return comp;
	}

	@Override
	public Component getParent() {
		// HorizontalPanelをparentにしない
		Component parent = comp.getData("parent");
		if(parent==null){
			parent =  GxtUtil.findParent(comp);
			comp.setData("parent", parent);
		}
		return parent;
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		if (parent == DesignPanel.getInstance().getBasePanel()) {
			return false;
		}
		return super.isAddableToParent(parent);
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-BB";
	}


}
