/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.DateField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.TimeField;
import com.extjs.gxt.ui.client.widget.form.FormPanel.Encoding;
import com.extjs.gxt.ui.client.widget.form.FormPanel.LabelAlign;
import com.extjs.gxt.ui.client.widget.form.FormPanel.Method;

public class FormPanelDelegate extends ContentPanelDelegate {

	private FormPanel comp;

	protected String[] props = { "readOnly", "fieldWidth", "labelAlign",
			"labelWidth" };

	protected String[] innerProps = { "action", "encoding", "labelWidth",
			"labelAlign", "fieldWidth", "method" };

	public FormPanelDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (FormPanel) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getFields".equals(mthodName)) {
			return comp.getFields();
		} else if ("getMethod".equals(mthodName)) {
			return comp.getMethod();
		} else if ("setReadOnly".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setReadOnly((Boolean) parms[0]);
			return comp;
		} else if ("getEncoding".equals(mthodName)) {
			return comp.getEncoding();
		} else if ("setMethod".equals(mthodName) && parms[0] instanceof Method) {
			comp.setMethod((Method) parms[0]);
			return comp;
		} else if ("isValid".equals(mthodName)) {
			return comp.isValid();
		} else if ("getAction".equals(mthodName)) {
			return comp.getAction();
		} else if ("getFieldWidth".equals(mthodName)) {
			return comp.getFieldWidth();
		} else if ("getLabelAlign".equals(mthodName)) {
			return comp.getLabelAlign();
		} else if ("getLabelWidth".equals(mthodName)) {
			return comp.getLabelWidth();
		} else if ("getLayoutTarget".equals(mthodName)) {
			return comp.getLayoutTarget();
		} else if ("getTarget".equals(mthodName)) {
			return comp.getTarget();
		} else if ("isDirty".equals(mthodName)) {
			return comp.isDirty();
		} else if ("setAction".equals(mthodName) && parms[0] instanceof String) {
			comp.setAction((String) parms[0]);
			return comp;
		} else if ("setEncoding".equals(mthodName)
				&& parms[0] instanceof Encoding) {
			comp.setEncoding((Encoding) parms[0]);
			return comp;
		} else if ("setFieldWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setFieldWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setLabelAlign".equals(mthodName)
				&& parms[0] instanceof LabelAlign) {
			comp.setLabelAlign((LabelAlign) parms[0]);
			return comp;
		} else if ("setLabelWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setLabelWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Component setInitStyle(Component widget) {
		WidgetService ws = WidgetServiceFactory.getService(widget);
		widget.setTitle(GxtUtil.getNewTag(ws.getTag()));
		FormPanel simple = (FormPanel) widget;

		// Forms
		simple.setHeading("Simple Form");
		simple.setFrame(true);
		simple.setWidth(350);

		TextField<String> firstName = new TextField<String>();
		firstName.setFieldLabel("Name");
		firstName.setAllowBlank(false);
		firstName.setBorders(true);
		simple.add(firstName);

		TextField<String> email = new TextField<String>();
		email.setBorders(true);
		email.setFieldLabel("Email");
		simple.add(email);

		ComboBox<ModelData> combo = new ComboBox<ModelData>();
		combo.setFieldLabel("Company");
		combo.setDisplayField("name");
		combo.setStore(new ListStore<ModelData>());
		simple.add(combo);

		DateField date = new DateField();
		date.setFieldLabel("Birthday");
		simple.add(date);

		TimeField time = new TimeField();
		time.setFieldLabel("Time");
		simple.add(time);

		CheckBox check1 = new CheckBox();
		check1.setBoxLabel("Classical");

		CheckBox check2 = new CheckBox();
		check2.setBoxLabel("Rock");
		check2.setValue(true);

		CheckBox check3 = new CheckBox();
		check3.setBoxLabel("Blue");

		CheckBoxGroup checkGroup = new CheckBoxGroup();
		checkGroup.setFieldLabel("Music");
		checkGroup.add(check1);
		checkGroup.add(check2);
		checkGroup.add(check3);
		// D-Rex performance 対策
		check1.setData("parent", checkGroup);
		check2.setData("parent", checkGroup);
		check3.setData("parent", checkGroup);
		simple.add(checkGroup);

		Radio radio = new Radio();
		radio.setName("radio");
		radio.setBoxLabel("Red");
		radio.setValue(true);

		Radio radio2 = new Radio();
		radio2.setName("radio");
		radio2.setBoxLabel("Blue");

		RadioGroup radioGroup = new RadioGroup("test");
		radioGroup.setFieldLabel("Favorite Color");
		radioGroup.add(radio);
		radioGroup.add(radio2);
		// D-Rex performance 対策
		radio.setData("parent", radioGroup);
		radio2.setData("parent", radioGroup);
		simple.add(radioGroup);

		TextArea description = new TextArea();
		description.setPreventScrollbars(true);
		description.setBorders(true);
		description.setFieldLabel("Description");
		simple.add(description);

		return simple;
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-FP";
	}


}
