/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ConfigWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Header;

public class HeaderDelegate extends ComponentDelegate {

	private Header comp;

	protected String[] props = { "text", "textStyle", "iconStyle" };

	protected String[] innerProps = { "text", "textStyle", "iconStyle" };

	public HeaderDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (Header) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("setText".equals(mthodName) && parms[0] instanceof String) {
			comp.setText((String) parms[0]);
			return comp;
		} else if ("getIcon".equals(mthodName)) {
			return comp.getIcon();
		} else if ("getIconStyle".equals(mthodName)) {
			return comp.getIconStyle();
		} else if ("getText".equals(mthodName)) {
			return comp.getText();
		} else if ("getTextStyle".equals(mthodName)) {
			return comp.getTextStyle();
		} else if ("getToolCount".equals(mthodName)) {
			return comp.getToolCount();
		} else if ("setIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setIconStyle((String) parms[0]);
			return comp;
		} else if ("setTextStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setTextStyle((String) parms[0]);
			return comp;
		} else if ("addTool".equals(mthodName) && parms[0] instanceof Component) {
			comp.addTool((Component) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public void addWidget(Component widget) {
		if (!(widget instanceof ConfigWidget)) {
			getDesignList().add(widget);
			comp.addTool(widget);
			return;
		}
		super.addWidget(widget);
	}

	private List<Component> getDesignList() {
		String key = "Design_list";
		List<Component> l = comp.getData(key);
		if (l == null) {
			l = new ArrayList<Component>();
			comp.setData(key, l);
		}
		return l;
	}

	@Override
	public Component removeWidget(Component widget) {
		comp.removeTool(widget);
		getDesignList().remove(widget);
		return comp;
	}

	@Override
	public boolean isAddable() {
		return true;
	}

	@Override
	public Component getParent() {
		// HorizontalPanelをparentにしない
		Component parent = comp.getData("parent");
		if (parent == null) {
			parent = GxtUtil.findParent(comp);
			comp.setData("parent", parent);
		}
		return parent;
	}

	@Override
	public List<Component> getChildren() {
		List<Component> l = super.getChildren();
		for (int i = 0; i < comp.getToolCount(); i++) {
			Component tool = comp.getTool(i);
			if (getDesignList().contains(tool)) {
				// D-Rexでaddしたもののみに絞る
				l.add(tool);
			}
		}
		return l;
	}

	@Override
	public Component setInitStyle(Component widget) {
		Header header = (Header) widget;
		header.setText(GxtUtil.getNewTag(service.getTag()));
		return header;
	}

	@Override
	public String getAddCode(Component widget, List<String>[] lists,
			String parentFiledName, String fieldName, Map<Object, Object> map) {
		if (!(widget instanceof ConfigWidget)) {
			return parentFiledName + ".addTool(" + fieldName + ");";
		}
		return super.getAddCode(widget, lists, parentFiledName, fieldName, map);
	}

	@Override
	public boolean isClickResize() {
		return true;
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-Hd";
	}


}
