/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;

public class HtmlDelegate extends BoxComponentDelegate {

	private Html comp;

	protected String[] props = { "tagName", "html" };

	protected String[] innerProps = { "tagName", "html" };

	public HtmlDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (Html) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("setHtml".equals(mthodName) && parms[0] instanceof String) {
			comp.setHtml((String) parms[0]);
			return comp;
		} else if ("getHtml".equals(mthodName)) {
			return comp.getHtml();
		} else if ("setTagName".equals(mthodName) && parms[0] instanceof String) {
			comp.setTagName((String) parms[0]);
			return comp;
		} else if ("getTagName".equals(mthodName)) {
			return comp.getTagName();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public Component setInitStyle(Component widget) {
		WidgetService ws = WidgetServiceFactory.getService(widget);
		String tag = GxtUtil.getNewTag(ws.getTag());
		widget.setTitle(tag);
		Html ht = (Html) widget;
		ht.setHtml(tag);
		return ht;
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-Ht";
	}


}
