/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ScrollContainer;

public class ScrollContainerDelegate extends ContainerDelegate {

	private ScrollContainer comp;

	protected String[] props = { "hScrollPosition", "scrollMode",
			"vScrollPosition" };

	protected String[] innerProps = { "hScrollPosition", "scrollMode",
			"vScrollPosition" };

	public ScrollContainerDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (ScrollContainer) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getHScrollPosition".equals(mthodName)) {
			return comp.getHScrollPosition();
		} else if ("getVScrollPosition".equals(mthodName)) {
			return comp.getVScrollPosition();
		} else if ("setHScrollPosition".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setHScrollPosition(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setVScrollPosition".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setVScrollPosition(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("getScrollMode".equals(mthodName)) {
			return comp.getScrollMode();
		} else if ("setScrollMode".equals(mthodName)
				&& parms[0] instanceof Scroll) {
			comp.setScrollMode((Scroll) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

}
