/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.TabPanel.TabPosition;

public class TabPanelDelegate extends ContainerDelegate {

	private TabPanel comp;

	protected String[] props = { "borderStyle", "resizeTabs", "autoSelect",
			"minTabWidth", "scrollDuration", "animScroll", "tabScroll",
			"bodyBorder", "tabWidth", "tabMargin", "tabPosition", "plain" };

	protected String[] innerProps = { "borderStyle", "resizeTabs",
			"autoSelect", "minTabWidth", "scrollDuration", "animScroll",
			"tabScroll", "bodyBorder", "tabWidth", "tabMargin", "tabPosition",
			"plain" };

	public TabPanelDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TabPanel) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getAnimScroll".equals(mthodName)) {
			return comp.getAnimScroll();
		} else if ("getBodyBorder".equals(mthodName)) {
			return comp.getBodyBorder();
		} else if ("getBorderStyle".equals(mthodName)) {
			return comp.getBorderStyle();
		} else if ("getMinTabWidth".equals(mthodName)) {
			return comp.getMinTabWidth();
		} else if ("getResizeTabs".equals(mthodName)) {
			return comp.getResizeTabs();
		} else if ("getScrollDuration".equals(mthodName)) {
			return comp.getScrollDuration();
		} else if ("getTabMargin".equals(mthodName)) {
			return comp.getTabMargin();
		} else if ("getTabPosition".equals(mthodName)) {
			return comp.getTabPosition();
		} else if ("getTabScroll".equals(mthodName)) {
			return comp.getTabScroll();
		} else if ("getTabWidth".equals(mthodName)) {
			return comp.getTabWidth();
		} else if ("isAutoSelect".equals(mthodName)) {
			return comp.isAutoSelect();
		} else if ("setAnimScroll".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAnimScroll((Boolean) parms[0]);
			return comp;
		} else if ("setAutoHeight".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAutoHeight((Boolean) parms[0]);
			return comp;
		} else if ("setAutoSelect".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAutoSelect((Boolean) parms[0]);
			return comp;
		} else if ("setBodyBorder".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setBodyBorder((Boolean) parms[0]);
			return comp;
		} else if ("setBorderStyle".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setBorderStyle((Boolean) parms[0]);
			return comp;
		} else if ("setMinTabWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMinTabWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setPlain".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setPlain((Boolean) parms[0]);
			return comp;
		} else if ("setResizeTabs".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setResizeTabs((Boolean) parms[0]);
			return comp;
		} else if ("setScrollDuration".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setScrollDuration(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setScrollIncrement".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setScrollIncrement(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setSelection".equals(mthodName)
				&& parms[0] instanceof TabItem) {
			comp.setSelection((TabItem) parms[0]);
			return comp;
		} else if ("setTabMargin".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setTabMargin(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setTabPosition".equals(mthodName)
				&& parms[0] instanceof TabPosition) {
			comp.setTabPosition((TabPosition) parms[0]);
			return comp;
		} else if ("setTabScroll".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setTabScroll((Boolean) parms[0]);
			return comp;
		} else if ("setTabWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setTabWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("isPlain".equals(mthodName)) {
			return comp.isPlain();
		} else if ("getSelectedItem".equals(mthodName)) {
			return comp.getSelectedItem();
		} else if ("add".equals(mthodName) && parms.length == 1
				&& parms[0] instanceof TabItem) {
			return comp.add((TabItem) parms[0]);
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public Component setInitStyle(Component widget) {
		WidgetService ws = WidgetServiceFactory.getService(widget);
		widget.setTitle(GxtUtil.getNewTag(ws.getTag()));
		TabPanel panel = (TabPanel) widget;

		// Basic Tabs
		panel.setPlain(true);
		panel.setSize(450, 250);

		TabItem normal = new TabItem("Normal");
		normal.addStyleName("pad-text");
		normal.addText("Just a plain old tab");
		panel.add(normal);
//
//		TabItem ajax1 = new TabItem("Ajax Tab");
//		ajax1.setScrollMode(Scroll.AUTO);
//		ajax1.addStyleName("pad-text");
//		ajax1.setAutoLoad(new RequestBuilder(RequestBuilder.GET, "ajax1.html"));
//		panel.add(ajax1);
//
//		TabItem eventTab = new TabItem("Event Tab");
//		eventTab.addListener(Events.Select, new Listener<ComponentEvent>() {
//			public void handleEvent(ComponentEvent be) {
//				Window.alert("Event Tab Was Selected");
//			}
//		});
//		eventTab.addStyleName("pad-text");
//		eventTab
//				.addText("I am tab 4's content. I also have an event listener attached.");
//		panel.add(eventTab);

//		TabItem disabled = new TabItem("Disabled");
//		disabled.setEnabled(false);
//		panel.add(disabled);

		return panel;
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof TabItem) {
			TabItem ti = (TabItem) widget;
			if (insertIdx != -1) {
				if (insertIdx > comp.getItemCount()) {
					insertIdx = comp.getItemCount();
				}
				comp.insert(ti, insertIdx);
				insertIdx = -1;
				return;
			} else {
				comp.add(ti);
				return;
			}
		}
	}

	@Override
	public Component removeWidget(Component widget) {
		if (widget instanceof TabItem) {
			TabItem ti = (TabItem) widget;
			comp.remove(ti);
		}
		return comp;
	}

	@Override
	public String getCategory() {
		return "Panel/Sample";
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-TP";
	}
}
