/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.Style.SelectionMode;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.tree.Tree;
import com.extjs.gxt.ui.client.widget.tree.TreeItem;
import com.extjs.gxt.ui.client.widget.tree.TreeSelectionModel;
import com.extjs.gxt.ui.client.widget.tree.Tree.CheckCascade;
import com.extjs.gxt.ui.client.widget.tree.Tree.CheckNodes;

public class TreeDelegate extends ContainerDelegate {

	private Tree comp;

	// selectionModel,selectedItem,selectedItems 不要
	protected String[] props = { "animate", "checkNodes", "contextMenu",
			"checkable", "openNodeIconStyle", "checkStyle", "selectionMode",
			"indentWidth", "nodeIconStyle", "itemIconStyle" };

	protected String[] innerProps = { "animate", "checkNodes", "contextMenu",
			"checkable", "openNodeIconStyle", "checkStyle", "selectionMode",
			"indentWidth", "nodeIconStyle", "itemIconStyle" };

	public TreeDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (Tree) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@SuppressWarnings("deprecation")
	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getAllItems".equals(mthodName)) {
			return comp.getAllItems();
		} else if ("getAllItemCount".equals(mthodName)) {
			return comp.getAllItemCount();
		} else if ("getAnimate".equals(mthodName)) {
			return comp.getAnimate();
		} else if ("getCheckable".equals(mthodName)) {
			return comp.getCheckable();
		} else if ("getChecked".equals(mthodName)) {
			return comp.getChecked();
		} else if ("getCheckNodes".equals(mthodName)) {
			return comp.getCheckNodes();
		} else if ("getCheckStyle".equals(mthodName)) {
			return comp.getCheckStyle();
		} else if ("getContextMenu".equals(mthodName)) {
			return comp.getContextMenu();
		} else if ("getIndentWidth".equals(mthodName)) {
			return comp.getIndentWidth();
		} else if ("getItemIconStyle".equals(mthodName)) {
			return comp.getItemIconStyle();
		} else if ("getNodeIconStyle".equals(mthodName)) {
			return comp.getNodeIconStyle();
		} else if ("getOpenNodeIconStyle".equals(mthodName)) {
			return comp.getOpenNodeIconStyle();
		} else if ("getRootItem".equals(mthodName)) {
			return comp.getRootItem();
		} else if ("getSelectedItems".equals(mthodName)) {
			return comp.getSelectedItems();
		} else if ("setAnimate".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAnimate((Boolean) parms[0]);
			return comp;
		} else if ("setCheckable".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setCheckable((Boolean) parms[0]);
			return comp;
		} else if ("setCheckNodes".equals(mthodName)
				&& parms[0] instanceof CheckNodes) {
			comp.setCheckNodes((CheckNodes) parms[0]);
			return comp;
		} else if ("setCheckStyle".equals(mthodName)
				&& parms[0] instanceof CheckCascade) {
			comp.setCheckStyle((CheckCascade) parms[0]);
			return comp;
		} else if ("setContextMenu".equals(mthodName)
				&& parms[0] instanceof Menu) {
			comp.setContextMenu((Menu) parms[0]);
			return comp;
		} else if ("setIndentWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setIndentWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setItemIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setItemIconStyle((String) parms[0]);
			return comp;
		} else if ("setNodeIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setNodeIconStyle((String) parms[0]);
			return comp;
		} else if ("setOpenNodeIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setOpenNodeIconStyle((String) parms[0]);
			return comp;
		} else if ("setSelectedItems".equals(mthodName)
				&& parms[0] instanceof List) {
			comp.setSelectedItems((List<TreeItem>) parms[0]);
			return comp;
		} else if ("getStyle".equals(mthodName)) {
			return comp.getStyle();
		} else if ("getSelectionModel".equals(mthodName)) {
			return comp.getSelectionModel();
		} else if ("setSelectionModel".equals(mthodName)
				&& parms[0] instanceof TreeSelectionModel) {
			comp.setSelectionModel((TreeSelectionModel) parms[0]);
			return comp;
		} else if ("getSelectedItem".equals(mthodName)) {
			return comp.getSelectedItem();
		} else if ("setSelectedItem".equals(mthodName)
				&& parms[0] instanceof TreeItem) {
			comp.setSelectedItem((TreeItem) parms[0]);
			return comp;
		} else if ("setSelectionMode".equals(mthodName)
				&& parms[0] instanceof SelectionMode) {
			comp.setSelectionMode((SelectionMode) parms[0]);
			return comp;
		} else if ("getSelectionMode".equals(mthodName)) {
			return comp.getSelectionMode();
		}
		return super.exec(mthodName, parms);
	}


	@Override
	public void addWidget(Component widget) {
		if (widget instanceof TreeItem) {
			TreeItem tri = (TreeItem) widget;
			comp.getRootItem().add(tri);
		}
	}

	@Override
	public Component removeWidget(Component widget) {
		if (widget instanceof TreeItem) {
			TreeItem tri = (TreeItem) widget;
			comp.getRootItem().remove(tri);
		}
		return comp;
	}

	@Override
	public boolean isClickResize() {
		return false;
	}

	@Override
	public List<Component> getChildren() {
		List<Component> l = super.getChildren();
		l.addAll(comp.getRootItem().getItems());
		return l;
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-Tr";
	}


}
