/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.AnchorLayoutWidget;

import com.extjs.gxt.ui.client.util.Size;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.layout.AbsoluteData;
import com.extjs.gxt.ui.client.widget.layout.AnchorData;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;

public class AnchorLayoutDelegate extends LayoutDelegate {

	private AnchorLayoutWidget comp;

	protected String[] props = { "anchorSize" };

	public AnchorLayoutDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (AnchorLayoutWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("setAnchorSize".equals(mthodName) && parms[0] instanceof Size) {
			comp.setAnchorSize((Size) parms[0]);
			return comp;
		} else if ("setAnchorSize".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setAnchorSize(GxtUtil.makeSize((String) parms[0]));
			return comp;
		} else if ("getAnchorSize".equals(mthodName)) {
			return comp.getAnchorSize();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public void resetLayoutWhenAdd(Component addComp) {
		LayoutData data = ComponentHelper.getLayoutData(addComp);
		if (!(data instanceof AnchorData) || data instanceof AbsoluteData
				|| data instanceof FormData) {
			ComponentHelper.setLayoutData(addComp, null);
		}
	}

	@Override
	public LayoutData getValidLayoutData() {
		return new AnchorData();
	}

}
