/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.BorderLayoutWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;


public class BorderLayoutDelegate extends LayoutDelegate {

	private BorderLayoutWidget comp;

	protected String[] props = { "containerStyle", "enableState" };

	public BorderLayoutDelegate(WidgetService service, Component widget
) {
		super(service, widget);
		this.comp = (BorderLayoutWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getEnableState".equals(mthodName)) {
			return comp.getEnableState();
		} else if ("getContainerStyle".equals(mthodName)) {
			return comp.getContainerStyle();
		} else if ("setContainerStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setContainerStyle((String) parms[0]);
			return comp;
		} else if ("setEnableState".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setEnableState((Boolean) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}
	@Override
	public LayoutData getValidLayoutData() {
		return new BorderLayoutData(null);
	}

}
