/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.FormLayoutWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.form.FormPanel.LabelAlign;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;

public class FormLayoutDelegate extends AnchorLayoutDelegate {

	private FormLayoutWidget comp;

	protected String[] props = { "defaultWidth", "hideLabels", "labelAlign",
			"labelPad", "labelSeparator", "labelWidth", "padding" };

	public FormLayoutDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (FormLayoutWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getDefaultWidth".equals(mthodName)) {
			return comp.getDefaultWidth();
		} else if ("getHideLabels".equals(mthodName)) {
			return comp.getHideLabels();
		} else if ("getLabelAlign".equals(mthodName)) {
			return comp.getLabelAlign();
		} else if ("getLabelPad".equals(mthodName)) {
			return comp.getLabelPad();
		} else if ("getLabelSeparator".equals(mthodName)) {
			return comp.getLabelSeparator();
		} else if ("getLabelWidth".equals(mthodName)) {
			return comp.getLabelWidth();
		} else if ("getPadding".equals(mthodName)) {
			return comp.getPadding();
		} else if ("setDefaultWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setDefaultWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setHideLabels".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setHideLabels((Boolean) parms[0]);
			return comp;
		} else if ("setLabelAlign".equals(mthodName)
				&& parms[0] instanceof LabelAlign) {
			comp.setLabelAlign((LabelAlign) parms[0]);
			return comp;
		} else if ("setLabelPad".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setLabelPad(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setLabelSeparator".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setLabelSeparator((String) parms[0]);
			return comp;
		} else if ("setLabelWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setLabelWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setPadding".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setPadding(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public void resetLayoutWhenAdd(Component addComp) {
		LayoutData data = ComponentHelper.getLayoutData(addComp);
		if (!(data instanceof FormData)) {
			ComponentHelper.setLayoutData(addComp, null);
		}
	}

	@Override
	public LayoutData getValidLayoutData() {
		return new FormData();

	}

}
