/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;

import java.util.List;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.TableLayoutWidget;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.Style.VerticalAlignment;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.LayoutContainerHelper;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;

public class TableLayoutDelegate extends LayoutDelegate {

	private TableLayoutWidget comp;

	protected String[] props = { "border", "cellHorizontalAlign",
			"cellPadding", "cellSpacing", "cellVerticalAlign", "columns",
			"insertSpacer", "tableStyle" };

	public TableLayoutDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TableLayoutWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getBorder".equals(mthodName)) {
			return comp.getBorder();
		} else if ("getCellHorizontalAlign".equals(mthodName)) {
			return comp.getCellHorizontalAlign();
		} else if ("getCellPadding".equals(mthodName)) {
			return comp.getCellPadding();
		} else if ("getCellVerticalAlign".equals(mthodName)) {
			return comp.getCellVerticalAlign();
		} else if ("getColumns".equals(mthodName)) {
			return comp.getColumns();
		} else if ("getInsertSpacer".equals(mthodName)) {
			return comp.getInsertSpacer();
		} else if ("getTableStyle".equals(mthodName)) {
			return comp.getTableStyle();
		} else if ("setBorder".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setBorder(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setCellHorizontalAlign".equals(mthodName)
				&& parms[0] instanceof HorizontalAlignment) {
			comp.setCellHorizontalAlign((HorizontalAlignment) parms[0]);
			return comp;
		} else if ("setCellPadding".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setCellPadding(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setCellSpacing".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setCellSpacing(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setCellVerticalAlign".equals(mthodName)
				&& parms[0] instanceof VerticalAlignment) {
			comp.setCellVerticalAlign((VerticalAlignment) parms[0]);
			return comp;
		} else if ("setColumns".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setColumns(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setInsertSpacer".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setInsertSpacer((Boolean) parms[0]);
			return comp;
		} else if ("setTableStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setTableStyle((String) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public LayoutData getValidLayoutData() {
		TableData td = new TableData();
		td.setHorizontalAlign(HorizontalAlignment.LEFT);
		return td;
	}

	@Override
	public void resetLayoutWhenAdd(Component addComp) {
		if (!(ComponentHelper.getLayoutData(addComp) instanceof TableData)) {
			setTableWidthHight(comp.getContainer());
		}
	}

	public static void setTableWidthHight(LayoutContainer container) {
		if (!(container.getLayout() instanceof TableLayout)) {
			return;
		}
		TableLayout layout = (TableLayout) container.getLayout();
		container.layout();
		List l = container.getItems();
		if (l.size() > 0) {
			int h = GxtUtil.safeParse(LayoutContainerHelper
					.getHeight(container).replace("px", ""));
			h = h / (1 + (l.size() - 1) / layout.getColumns());
			String w = LayoutContainerHelper.getWidth(container);
			for (int i = 0; i < l.size(); i++) {
				Component c = (Component) l.get(i);
				TableData td = new TableData();
				td.setHeight(h + "px");
				td.setWidth(w);
				ComponentHelper.setLayoutData(c, td);
			}
		}

	}

}
