/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetServiceBase;
import jp.co.kpscorp.gwt.client.design.delegate.Delegate;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.GridDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.layout.ColumnModelDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ArrayListWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnModelWidget;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;

public class WsColumnModel extends WidgetServiceBase {

	private String fieldString = "ColumnModel ";

	private String instanceString = " = new ColumnModel(%1);";

	private String tag = "gxCLMM";

	public WsColumnModel(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new ColumnModelDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	public Component getInstance() {
		ColumnModel data = new ColumnModel(new ArrayList<ColumnConfig>());
		Grid<ModelData> grid = new Grid<ModelData>(GridDelegate.makeStore(data,
				300), data);
		return new ColumnModelWidget(data, grid);
	}

	public String getLabel() {
		return "ColumnModel";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

	@Override
	public List<String>[] makeSource(List<String>[] lists,
			Map<Object, Object> map) {
		String fn = GxtUtil.getFieldName(lists[0], getFieldString(), getTag());
		lists[0].add(getFieldString() + fn + ";");
		lists[0].add("List " + fn + "_l;");
		lists[1].add(fn + "_l = new ArrayList();");
		lists[1].add(fn + getInstanceString().replace("%1", fn + "_l"));
		Iterator it = getDelegates().iterator();
		while (it.hasNext()) {
			Delegate delegate = (Delegate) it.next();
			delegate.makeSetterCode(widget, lists, getFieldString(),
					getInstanceString(), getTag(), fn, map);
		}
		return GxtUtil.makeAddCode(widget, lists, map, fn);
	}

	@Override
	public Component getInstance(String constracter, Map map) {
		int st = constracter.indexOf("ColumnModel(");
		if (st == -1) {
			return null;
		}
		int ed = constracter.lastIndexOf(")");
		List<String> l = GxtUtil.devideStr(constracter.substring(st + 12, ed), ',');
		ArrayListWidget<ColumnConfig> alw = (ArrayListWidget<ColumnConfig>) map.get(l.get(0));
		return new ColumnModelWidget(new ColumnModel(alw.getWrapList()), null);
	}

}
