/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.i18n.client.impl.CurrencyData;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrencyList
implements Iterable<CurrencyData> {
    protected JavaScriptObject dataMap;
    protected JavaScriptObject namesMap;

    public static CurrencyList get() {
        return CurrencyListInstance.instance;
    }

    public native CurrencyData getDefault();

    @Override
    public final Iterator<CurrencyData> iterator() {
        this.ensureCurrencyMap();
        ArrayList<String> keys = new ArrayList<String>();
        this.loadCurrencyKeys(keys);
        final Iterator<String> it = keys.iterator();
        return new Iterator<CurrencyData>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public CurrencyData next() {
                return CurrencyList.this.getEntry((String)it.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        };
    }

    public final CurrencyData lookup(String currencyCode) {
        this.ensureCurrencyMap();
        return this.getEntry(currencyCode);
    }

    public final String lookupName(String currencyCode) {
        this.ensureNamesMap();
        return this.getNamesEntry(currencyCode);
    }

    protected final void ensureCurrencyMap() {
        if (this.dataMap == null) {
            this.loadCurrencyMap();
        }
    }

    protected final void ensureNamesMap() {
        if (this.namesMap == null) {
            this.loadNamesMap();
        }
    }

    protected final native CurrencyData getEntry(String var1);

    protected final native String getNamesEntry(String var1);

    protected native void loadCurrencyMap();

    protected native void loadNamesMap();

    private native void loadCurrencyKeys(ArrayList<String> var1);

    private static class CurrencyListInstance {
        private static CurrencyList instance = (CurrencyList)GWT.create(CurrencyList.class);

        private CurrencyListInstance() {
        }
    }
}

